/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListTrustedEntitySetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListTrustedEntitySetsResponse;

public class ListTrustedEntitySetsIterable
implements SdkIterable<ListTrustedEntitySetsResponse> {
    private final GuardDutyClient client;
    private final ListTrustedEntitySetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustedEntitySetsIterable(GuardDutyClient client, ListTrustedEntitySetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrustedEntitySetsResponseFetcher();
    }

    public Iterator<ListTrustedEntitySetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> trustedEntitySetIds() {
        Function<ListTrustedEntitySetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustedEntitySetIds() != null) {
                return response.trustedEntitySetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrustedEntitySetsResponseFetcher
    implements SyncPageFetcher<ListTrustedEntitySetsResponse> {
        private ListTrustedEntitySetsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustedEntitySetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrustedEntitySetsResponse nextPage(ListTrustedEntitySetsResponse previousPage) {
            if (previousPage == null) {
                return ListTrustedEntitySetsIterable.this.client.listTrustedEntitySets(ListTrustedEntitySetsIterable.this.firstRequest);
            }
            return ListTrustedEntitySetsIterable.this.client.listTrustedEntitySets((ListTrustedEntitySetsRequest)((Object)ListTrustedEntitySetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

