/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ClusterStatus;
import software.amazon.awssdk.services.guardduty.model.Ec2InstanceUidsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksCluster> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EksCluster.getter(EksCluster::arn)).setter(EksCluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(EksCluster.getter(EksCluster::createdAt)).setter(EksCluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EksCluster.getter(EksCluster::statusAsString)).setter(EksCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(EksCluster.getter(EksCluster::vpcId)).setter(EksCluster.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()}).build();
    private static final SdkField<List<String>> EC2_INSTANCE_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2InstanceUids").getter(EksCluster.getter(EksCluster::ec2InstanceUids)).setter(EksCluster.setter(Builder::ec2InstanceUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD, VPC_ID_FIELD, EC2_INSTANCE_UIDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String status;
    private final String vpcId;
    private final List<String> ec2InstanceUids;

    private EksCluster(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.vpcId = builder.vpcId;
        this.ec2InstanceUids = builder.ec2InstanceUids;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasEc2InstanceUids() {
        return this.ec2InstanceUids != null && !(this.ec2InstanceUids instanceof SdkAutoConstructList);
    }

    public final List<String> ec2InstanceUids() {
        return this.ec2InstanceUids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceUids() ? this.ec2InstanceUids() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksCluster)) {
            return false;
        }
        EksCluster other = (EksCluster)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasEc2InstanceUids() == other.hasEc2InstanceUids() && Objects.equals(this.ec2InstanceUids(), other.ec2InstanceUids());
    }

    public final String toString() {
        return ToString.builder((String)"EksCluster").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("VpcId", (Object)this.vpcId()).add("Ec2InstanceUids", this.hasEc2InstanceUids() ? this.ec2InstanceUids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Ec2InstanceUids": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceUids()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        map.put("ec2InstanceUids", EC2_INSTANCE_UIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksCluster, T> g) {
        return obj -> g.apply((EksCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String status;
        private String vpcId;
        private List<String> ec2InstanceUids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EksCluster model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.vpcId(model.vpcId);
            this.ec2InstanceUids(model.ec2InstanceUids);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getEc2InstanceUids() {
            if (this.ec2InstanceUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2InstanceUids;
        }

        public final void setEc2InstanceUids(Collection<String> ec2InstanceUids) {
            this.ec2InstanceUids = Ec2InstanceUidsCopier.copy(ec2InstanceUids);
        }

        @Override
        public final Builder ec2InstanceUids(Collection<String> ec2InstanceUids) {
            this.ec2InstanceUids = Ec2InstanceUidsCopier.copy(ec2InstanceUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceUids(String ... ec2InstanceUids) {
            this.ec2InstanceUids(Arrays.asList(ec2InstanceUids));
            return this;
        }

        public EksCluster build() {
            return new EksCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksCluster> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder vpcId(String var1);

        public Builder ec2InstanceUids(Collection<String> var1);

        public Builder ec2InstanceUids(String ... var1);
    }
}

