/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.PublicAccessConfiguration;
import software.amazon.awssdk.services.guardduty.model.PublicAccessStatus;
import software.amazon.awssdk.services.guardduty.model.S3ObjectUidsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Bucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Bucket> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(S3Bucket.getter(S3Bucket::ownerId)).setter(S3Bucket.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(S3Bucket.getter(S3Bucket::createdAt)).setter(S3Bucket.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(S3Bucket.getter(S3Bucket::encryptionType)).setter(S3Bucket.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(S3Bucket.getter(S3Bucket::encryptionKeyArn)).setter(S3Bucket.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final SdkField<String> EFFECTIVE_PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectivePermission").getter(S3Bucket.getter(S3Bucket::effectivePermission)).setter(S3Bucket.setter(Builder::effectivePermission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectivePermission").build()}).build();
    private static final SdkField<String> PUBLIC_READ_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicReadAccess").getter(S3Bucket.getter(S3Bucket::publicReadAccessAsString)).setter(S3Bucket.setter(Builder::publicReadAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicReadAccess").build()}).build();
    private static final SdkField<String> PUBLIC_WRITE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicWriteAccess").getter(S3Bucket.getter(S3Bucket::publicWriteAccessAsString)).setter(S3Bucket.setter(Builder::publicWriteAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicWriteAccess").build()}).build();
    private static final SdkField<PublicAccessConfiguration> ACCOUNT_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountPublicAccess").getter(S3Bucket.getter(S3Bucket::accountPublicAccess)).setter(S3Bucket.setter(Builder::accountPublicAccess)).constructor(PublicAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPublicAccess").build()}).build();
    private static final SdkField<PublicAccessConfiguration> BUCKET_PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketPublicAccess").getter(S3Bucket.getter(S3Bucket::bucketPublicAccess)).setter(S3Bucket.setter(Builder::bucketPublicAccess)).constructor(PublicAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPublicAccess").build()}).build();
    private static final SdkField<List<String>> S3_OBJECT_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3ObjectUids").getter(S3Bucket.getter(S3Bucket::s3ObjectUids)).setter(S3Bucket.setter(Builder::s3ObjectUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CREATED_AT_FIELD, ENCRYPTION_TYPE_FIELD, ENCRYPTION_KEY_ARN_FIELD, EFFECTIVE_PERMISSION_FIELD, PUBLIC_READ_ACCESS_FIELD, PUBLIC_WRITE_ACCESS_FIELD, ACCOUNT_PUBLIC_ACCESS_FIELD, BUCKET_PUBLIC_ACCESS_FIELD, S3_OBJECT_UIDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Bucket.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final Instant createdAt;
    private final String encryptionType;
    private final String encryptionKeyArn;
    private final String effectivePermission;
    private final String publicReadAccess;
    private final String publicWriteAccess;
    private final PublicAccessConfiguration accountPublicAccess;
    private final PublicAccessConfiguration bucketPublicAccess;
    private final List<String> s3ObjectUids;

    private S3Bucket(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.createdAt = builder.createdAt;
        this.encryptionType = builder.encryptionType;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.effectivePermission = builder.effectivePermission;
        this.publicReadAccess = builder.publicReadAccess;
        this.publicWriteAccess = builder.publicWriteAccess;
        this.accountPublicAccess = builder.accountPublicAccess;
        this.bucketPublicAccess = builder.bucketPublicAccess;
        this.s3ObjectUids = builder.s3ObjectUids;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String encryptionType() {
        return this.encryptionType;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String effectivePermission() {
        return this.effectivePermission;
    }

    public final PublicAccessStatus publicReadAccess() {
        return PublicAccessStatus.fromValue(this.publicReadAccess);
    }

    public final String publicReadAccessAsString() {
        return this.publicReadAccess;
    }

    public final PublicAccessStatus publicWriteAccess() {
        return PublicAccessStatus.fromValue(this.publicWriteAccess);
    }

    public final String publicWriteAccessAsString() {
        return this.publicWriteAccess;
    }

    public final PublicAccessConfiguration accountPublicAccess() {
        return this.accountPublicAccess;
    }

    public final PublicAccessConfiguration bucketPublicAccess() {
        return this.bucketPublicAccess;
    }

    public final boolean hasS3ObjectUids() {
        return this.s3ObjectUids != null && !(this.s3ObjectUids instanceof SdkAutoConstructList);
    }

    public final List<String> s3ObjectUids() {
        return this.s3ObjectUids;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectivePermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicReadAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicWriteAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3ObjectUids() ? this.s3ObjectUids() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.encryptionType(), other.encryptionType()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.effectivePermission(), other.effectivePermission()) && Objects.equals(this.publicReadAccessAsString(), other.publicReadAccessAsString()) && Objects.equals(this.publicWriteAccessAsString(), other.publicWriteAccessAsString()) && Objects.equals(this.accountPublicAccess(), other.accountPublicAccess()) && Objects.equals(this.bucketPublicAccess(), other.bucketPublicAccess()) && this.hasS3ObjectUids() == other.hasS3ObjectUids() && Objects.equals(this.s3ObjectUids(), other.s3ObjectUids());
    }

    public final String toString() {
        return ToString.builder((String)"S3Bucket").add("OwnerId", (Object)this.ownerId()).add("CreatedAt", (Object)this.createdAt()).add("EncryptionType", (Object)this.encryptionType()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("EffectivePermission", (Object)this.effectivePermission()).add("PublicReadAccess", (Object)this.publicReadAccessAsString()).add("PublicWriteAccess", (Object)this.publicWriteAccessAsString()).add("AccountPublicAccess", (Object)this.accountPublicAccess()).add("BucketPublicAccess", (Object)this.bucketPublicAccess()).add("S3ObjectUids", this.hasS3ObjectUids() ? this.s3ObjectUids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionType()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "EffectivePermission": {
                return Optional.ofNullable(clazz.cast(this.effectivePermission()));
            }
            case "PublicReadAccess": {
                return Optional.ofNullable(clazz.cast(this.publicReadAccessAsString()));
            }
            case "PublicWriteAccess": {
                return Optional.ofNullable(clazz.cast(this.publicWriteAccessAsString()));
            }
            case "AccountPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.accountPublicAccess()));
            }
            case "BucketPublicAccess": {
                return Optional.ofNullable(clazz.cast(this.bucketPublicAccess()));
            }
            case "S3ObjectUids": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectUids()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerId", OWNER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("effectivePermission", EFFECTIVE_PERMISSION_FIELD);
        map.put("publicReadAccess", PUBLIC_READ_ACCESS_FIELD);
        map.put("publicWriteAccess", PUBLIC_WRITE_ACCESS_FIELD);
        map.put("accountPublicAccess", ACCOUNT_PUBLIC_ACCESS_FIELD);
        map.put("bucketPublicAccess", BUCKET_PUBLIC_ACCESS_FIELD);
        map.put("s3ObjectUids", S3_OBJECT_UIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Bucket, T> g) {
        return obj -> g.apply((S3Bucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private Instant createdAt;
        private String encryptionType;
        private String encryptionKeyArn;
        private String effectivePermission;
        private String publicReadAccess;
        private String publicWriteAccess;
        private PublicAccessConfiguration accountPublicAccess;
        private PublicAccessConfiguration bucketPublicAccess;
        private List<String> s3ObjectUids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3Bucket model) {
            this.ownerId(model.ownerId);
            this.createdAt(model.createdAt);
            this.encryptionType(model.encryptionType);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.effectivePermission(model.effectivePermission);
            this.publicReadAccess(model.publicReadAccess);
            this.publicWriteAccess(model.publicWriteAccess);
            this.accountPublicAccess(model.accountPublicAccess);
            this.bucketPublicAccess(model.bucketPublicAccess);
            this.s3ObjectUids(model.s3ObjectUids);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEffectivePermission() {
            return this.effectivePermission;
        }

        public final void setEffectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
        }

        @Override
        public final Builder effectivePermission(String effectivePermission) {
            this.effectivePermission = effectivePermission;
            return this;
        }

        public final String getPublicReadAccess() {
            return this.publicReadAccess;
        }

        public final void setPublicReadAccess(String publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
        }

        @Override
        public final Builder publicReadAccess(String publicReadAccess) {
            this.publicReadAccess = publicReadAccess;
            return this;
        }

        @Override
        public final Builder publicReadAccess(PublicAccessStatus publicReadAccess) {
            this.publicReadAccess(publicReadAccess == null ? null : publicReadAccess.toString());
            return this;
        }

        public final String getPublicWriteAccess() {
            return this.publicWriteAccess;
        }

        public final void setPublicWriteAccess(String publicWriteAccess) {
            this.publicWriteAccess = publicWriteAccess;
        }

        @Override
        public final Builder publicWriteAccess(String publicWriteAccess) {
            this.publicWriteAccess = publicWriteAccess;
            return this;
        }

        @Override
        public final Builder publicWriteAccess(PublicAccessStatus publicWriteAccess) {
            this.publicWriteAccess(publicWriteAccess == null ? null : publicWriteAccess.toString());
            return this;
        }

        public final PublicAccessConfiguration.Builder getAccountPublicAccess() {
            return this.accountPublicAccess != null ? this.accountPublicAccess.toBuilder() : null;
        }

        public final void setAccountPublicAccess(PublicAccessConfiguration.BuilderImpl accountPublicAccess) {
            this.accountPublicAccess = accountPublicAccess != null ? accountPublicAccess.build() : null;
        }

        @Override
        public final Builder accountPublicAccess(PublicAccessConfiguration accountPublicAccess) {
            this.accountPublicAccess = accountPublicAccess;
            return this;
        }

        public final PublicAccessConfiguration.Builder getBucketPublicAccess() {
            return this.bucketPublicAccess != null ? this.bucketPublicAccess.toBuilder() : null;
        }

        public final void setBucketPublicAccess(PublicAccessConfiguration.BuilderImpl bucketPublicAccess) {
            this.bucketPublicAccess = bucketPublicAccess != null ? bucketPublicAccess.build() : null;
        }

        @Override
        public final Builder bucketPublicAccess(PublicAccessConfiguration bucketPublicAccess) {
            this.bucketPublicAccess = bucketPublicAccess;
            return this;
        }

        public final Collection<String> getS3ObjectUids() {
            if (this.s3ObjectUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3ObjectUids;
        }

        public final void setS3ObjectUids(Collection<String> s3ObjectUids) {
            this.s3ObjectUids = S3ObjectUidsCopier.copy(s3ObjectUids);
        }

        @Override
        public final Builder s3ObjectUids(Collection<String> s3ObjectUids) {
            this.s3ObjectUids = S3ObjectUidsCopier.copy(s3ObjectUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3ObjectUids(String ... s3ObjectUids) {
            this.s3ObjectUids(Arrays.asList(s3ObjectUids));
            return this;
        }

        public S3Bucket build() {
            return new S3Bucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Bucket> {
        public Builder ownerId(String var1);

        public Builder createdAt(Instant var1);

        public Builder encryptionType(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder effectivePermission(String var1);

        public Builder publicReadAccess(String var1);

        public Builder publicReadAccess(PublicAccessStatus var1);

        public Builder publicWriteAccess(String var1);

        public Builder publicWriteAccess(PublicAccessStatus var1);

        public Builder accountPublicAccess(PublicAccessConfiguration var1);

        default public Builder accountPublicAccess(Consumer<PublicAccessConfiguration.Builder> accountPublicAccess) {
            return this.accountPublicAccess((PublicAccessConfiguration)((PublicAccessConfiguration.Builder)PublicAccessConfiguration.builder().applyMutation(accountPublicAccess)).build());
        }

        public Builder bucketPublicAccess(PublicAccessConfiguration var1);

        default public Builder bucketPublicAccess(Consumer<PublicAccessConfiguration.Builder> bucketPublicAccess) {
            return this.bucketPublicAccess((PublicAccessConfiguration)((PublicAccessConfiguration.Builder)PublicAccessConfiguration.builder().applyMutation(bucketPublicAccess)).build());
        }

        public Builder s3ObjectUids(Collection<String> var1);

        public Builder s3ObjectUids(String ... var1);
    }
}

