/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.ListThreatEntitySetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatEntitySetsResponse;

public class ListThreatEntitySetsPublisher
implements SdkPublisher<ListThreatEntitySetsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListThreatEntitySetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThreatEntitySetsPublisher(GuardDutyAsyncClient client, ListThreatEntitySetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThreatEntitySetsPublisher(GuardDutyAsyncClient client, ListThreatEntitySetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThreatEntitySetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThreatEntitySetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> threatEntitySetIds() {
        Function<ListThreatEntitySetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.threatEntitySetIds() != null) {
                return response.threatEntitySetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThreatEntitySetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThreatEntitySetsResponseFetcher
    implements AsyncPageFetcher<ListThreatEntitySetsResponse> {
        private ListThreatEntitySetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatEntitySetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThreatEntitySetsResponse> nextPage(ListThreatEntitySetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatEntitySetsPublisher.this.client.listThreatEntitySets(ListThreatEntitySetsPublisher.this.firstRequest);
            }
            return ListThreatEntitySetsPublisher.this.client.listThreatEntitySets((ListThreatEntitySetsRequest)((Object)ListThreatEntitySetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

