/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersRequest extends GuardDutyRequest implements
        ToCopyableBuilder<ListMembersRequest.Builder, ListMembersRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMembersRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListMembersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMembersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ONLY_ASSOCIATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMembersRequest::onlyAssociated)).setter(setter(Builder::onlyAssociated))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("onlyAssociated").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ONLY_ASSOCIATED_FIELD));

    private final String detectorId;

    private final Integer maxResults;

    private final String nextToken;

    private final String onlyAssociated;

    private ListMembersRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.onlyAssociated = builder.onlyAssociated;
    }

    /**
     * <p>
     * The unique ID of the detector the member is associated with.
     * </p>
     * 
     * @return The unique ID of the detector the member is associated with.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * You can use this parameter to indicate the maximum number of items you want in the response. The default value is
     * 50. The maximum value is 50.
     * </p>
     * 
     * @return You can use this parameter to indicate the maximum number of items you want in the response. The default
     *         value is 50. The maximum value is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action fill nextToken in the request with the value of NextToken
     * from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the list action. For subsequent calls to the action fill nextToken in the request with the value
     *         of NextToken from the previous response to continue listing data.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies whether to only return associated members or to return all members (including members which haven't
     * been invited yet or have been disassociated).
     * </p>
     * 
     * @return Specifies whether to only return associated members or to return all members (including members which
     *         haven't been invited yet or have been disassociated).
     */
    public String onlyAssociated() {
        return onlyAssociated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(onlyAssociated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersRequest)) {
            return false;
        }
        ListMembersRequest other = (ListMembersRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(onlyAssociated(), other.onlyAssociated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMembersRequest").add("DetectorId", detectorId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OnlyAssociated", onlyAssociated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OnlyAssociated":
            return Optional.ofNullable(clazz.cast(onlyAssociated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersRequest, T> g) {
        return obj -> g.apply((ListMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersRequest> {
        /**
         * <p>
         * The unique ID of the detector the member is associated with.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector the member is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * You can use this parameter to indicate the maximum number of items you want in the response. The default
         * value is 50. The maximum value is 50.
         * </p>
         * 
         * @param maxResults
         *        You can use this parameter to indicate the maximum number of items you want in the response. The
         *        default value is 50. The maximum value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the list action. For subsequent calls to the action fill nextToken in the request with the value of
         * NextToken from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the list action. For subsequent calls to the action fill nextToken in the request with
         *        the value of NextToken from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies whether to only return associated members or to return all members (including members which haven't
         * been invited yet or have been disassociated).
         * </p>
         * 
         * @param onlyAssociated
         *        Specifies whether to only return associated members or to return all members (including members which
         *        haven't been invited yet or have been disassociated).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onlyAssociated(String onlyAssociated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private Integer maxResults;

        private String nextToken;

        private String onlyAssociated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersRequest model) {
            super(model);
            detectorId(model.detectorId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            onlyAssociated(model.onlyAssociated);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOnlyAssociated() {
            return onlyAssociated;
        }

        @Override
        public final Builder onlyAssociated(String onlyAssociated) {
            this.onlyAssociated = onlyAssociated;
            return this;
        }

        public final void setOnlyAssociated(String onlyAssociated) {
            this.onlyAssociated = onlyAssociated;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMembersRequest build() {
            return new ListMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
