/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceId").build())
            .build();

    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateDnsName)).setter(setter(Builder::privateDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsName").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::privateIpAddress)).setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<List<PrivateIpAddressDetails>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<PrivateIpAddressDetails>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateIpAddressDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateIpAddressDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PUBLIC_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::publicDnsName)).setter(setter(Builder::publicDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDnsName").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIp").build()).build();

    private static final SdkField<List<SecurityGroup>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(NetworkInterface::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInterface::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_ADDRESSES_FIELD,
            NETWORK_INTERFACE_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            PUBLIC_DNS_NAME_FIELD, PUBLIC_IP_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<PrivateIpAddressDetails> privateIpAddresses;

    private final String publicDnsName;

    private final String publicIp;

    private final List<SecurityGroup> securityGroups;

    private final String subnetId;

    private final String vpcId;

    private NetworkInterface(BuilderImpl builder) {
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A list of EC2 instance IPv6 address information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of EC2 instance IPv6 address information.
     */
    public List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface
     * </p>
     * 
     * @return The ID of the network interface
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Private DNS name of the EC2 instance.
     * </p>
     * 
     * @return Private DNS name of the EC2 instance.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * Private IP address of the EC2 instance.
     * </p>
     * 
     * @return Private IP address of the EC2 instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * Other private IP address information of the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Other private IP address information of the EC2 instance.
     */
    public List<PrivateIpAddressDetails> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * Public DNS name of the EC2 instance.
     * </p>
     * 
     * @return Public DNS name of the EC2 instance.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * Public IP address of the EC2 instance.
     * </p>
     * 
     * @return Public IP address of the EC2 instance.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * Security groups associated with the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Security groups associated with the EC2 instance.
     */
    public List<SecurityGroup> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The subnet ID of the EC2 instance.
     * </p>
     * 
     * @return The subnet ID of the EC2 instance.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The VPC ID of the EC2 instance.
     * </p>
     * 
     * @return The VPC ID of the EC2 instance.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(publicDnsName(), other.publicDnsName()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInterface").add("Ipv6Addresses", ipv6Addresses())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateDnsName", privateDnsName())
                .add("PrivateIpAddress", privateIpAddress()).add("PrivateIpAddresses", privateIpAddresses())
                .add("PublicDnsName", publicDnsName()).add("PublicIp", publicIp()).add("SecurityGroups", securityGroups())
                .add("SubnetId", subnetId()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateDnsName":
            return Optional.ofNullable(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "PublicDnsName":
            return Optional.ofNullable(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * A list of EC2 instance IPv6 address information.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of EC2 instance IPv6 address information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * A list of EC2 instance IPv6 address information.
         * </p>
         * 
         * @param ipv6Addresses
         *        A list of EC2 instance IPv6 address information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Private DNS name of the EC2 instance.
         * </p>
         * 
         * @param privateDnsName
         *        Private DNS name of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * Private IP address of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddress
         *        Private IP address of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * 
         * @param privateIpAddresses
         *        Other private IP address information of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses);

        /**
         * <p>
         * Other private IP address information of the EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrivateIpAddressDetails>.Builder} avoiding
         * the need to create one manually via {@link List<PrivateIpAddressDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrivateIpAddressDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #privateIpAddresses(List<PrivateIpAddressDetails>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on {@link List<PrivateIpAddressDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(List<PrivateIpAddressDetails>)
         */
        Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses);

        /**
         * <p>
         * Public DNS name of the EC2 instance.
         * </p>
         * 
         * @param publicDnsName
         *        Public DNS name of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * Public IP address of the EC2 instance.
         * </p>
         * 
         * @param publicIp
         *        Public IP address of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * Security groups associated with the EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        Security groups associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroup> securityGroups);

        /**
         * <p>
         * Security groups associated with the EC2 instance.
         * </p>
         * 
         * @param securityGroups
         *        Security groups associated with the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroup... securityGroups);

        /**
         * <p>
         * Security groups associated with the EC2 instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroup>.Builder} avoiding the need
         * to create one manually via {@link List<SecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #securityGroups(List<SecurityGroup>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on {@link List<SecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(List<SecurityGroup>)
         */
        Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups);

        /**
         * <p>
         * The subnet ID of the EC2 instance.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The VPC ID of the EC2 instance.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<PrivateIpAddressDetails> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String publicDnsName;

        private String publicIp;

        private List<SecurityGroup> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String subnetId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
        }

        public final Collection<String> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressesCopier.copy(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<PrivateIpAddressDetails.Builder> getPrivateIpAddresses() {
            return privateIpAddresses != null ? privateIpAddresses.stream().map(PrivateIpAddressDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressDetails> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressDetails... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressDetails.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses).map(c -> PrivateIpAddressDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressDetails.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressesCopier.copyFromBuilder(privateIpAddresses);
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Collection<SecurityGroup.Builder> getSecurityGroups() {
            return securityGroups != null ? securityGroups.stream().map(SecurityGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroup.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copyFromBuilder(securityGroups);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
