/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnarchiveFindingsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UnarchiveFindingsRequest.Builder, UnarchiveFindingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnarchiveFindingsRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UnarchiveFindingsRequest::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FINDING_IDS_FIELD));

    private final String detectorId;

    private final List<String> findingIds;

    private UnarchiveFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingIds = builder.findingIds;
    }

    /**
     * <p>
     * The ID of the detector that specifies the GuardDuty service whose findings you want to unarchive.
     * </p>
     * 
     * @return The ID of the detector that specifies the GuardDuty service whose findings you want to unarchive.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * IDs of the findings that you want to unarchive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IDs of the findings that you want to unarchive.
     */
    public List<String> findingIds() {
        return findingIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(findingIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnarchiveFindingsRequest)) {
            return false;
        }
        UnarchiveFindingsRequest other = (UnarchiveFindingsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(findingIds(), other.findingIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnarchiveFindingsRequest").add("DetectorId", detectorId()).add("FindingIds", findingIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FindingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnarchiveFindingsRequest, T> g) {
        return obj -> g.apply((UnarchiveFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UnarchiveFindingsRequest> {
        /**
         * <p>
         * The ID of the detector that specifies the GuardDuty service whose findings you want to unarchive.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that specifies the GuardDuty service whose findings you want to unarchive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * IDs of the findings that you want to unarchive.
         * </p>
         * 
         * @param findingIds
         *        IDs of the findings that you want to unarchive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * IDs of the findings that you want to unarchive.
         * </p>
         * 
         * @param findingIds
         *        IDs of the findings that you want to unarchive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnarchiveFindingsRequest model) {
            super(model);
            detectorId(model.detectorId);
            findingIds(model.findingIds);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<String> getFindingIds() {
            return findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnarchiveFindingsRequest build() {
            return new UnarchiveFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
