/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Action::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<AwsApiCallAction> AWS_API_CALL_ACTION_FIELD = SdkField
            .<AwsApiCallAction> builder(MarshallingType.SDK_POJO).getter(getter(Action::awsApiCallAction))
            .setter(setter(Builder::awsApiCallAction)).constructor(AwsApiCallAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsApiCallAction").build()).build();

    private static final SdkField<DnsRequestAction> DNS_REQUEST_ACTION_FIELD = SdkField
            .<DnsRequestAction> builder(MarshallingType.SDK_POJO).getter(getter(Action::dnsRequestAction))
            .setter(setter(Builder::dnsRequestAction)).constructor(DnsRequestAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRequestAction").build()).build();

    private static final SdkField<NetworkConnectionAction> NETWORK_CONNECTION_ACTION_FIELD = SdkField
            .<NetworkConnectionAction> builder(MarshallingType.SDK_POJO).getter(getter(Action::networkConnectionAction))
            .setter(setter(Builder::networkConnectionAction)).constructor(NetworkConnectionAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConnectionAction").build())
            .build();

    private static final SdkField<PortProbeAction> PORT_PROBE_ACTION_FIELD = SdkField
            .<PortProbeAction> builder(MarshallingType.SDK_POJO).getter(getter(Action::portProbeAction))
            .setter(setter(Builder::portProbeAction)).constructor(PortProbeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portProbeAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            AWS_API_CALL_ACTION_FIELD, DNS_REQUEST_ACTION_FIELD, NETWORK_CONNECTION_ACTION_FIELD, PORT_PROBE_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final AwsApiCallAction awsApiCallAction;

    private final DnsRequestAction dnsRequestAction;

    private final NetworkConnectionAction networkConnectionAction;

    private final PortProbeAction portProbeAction;

    private Action(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.awsApiCallAction = builder.awsApiCallAction;
        this.dnsRequestAction = builder.dnsRequestAction;
        this.networkConnectionAction = builder.networkConnectionAction;
        this.portProbeAction = builder.portProbeAction;
    }

    /**
     * <p>
     * GuardDuty Finding activity type.
     * </p>
     * 
     * @return GuardDuty Finding activity type.
     */
    public String actionType() {
        return actionType;
    }

    /**
     * <p>
     * Information about the AWS_API_CALL action described in this finding.
     * </p>
     * 
     * @return Information about the AWS_API_CALL action described in this finding.
     */
    public AwsApiCallAction awsApiCallAction() {
        return awsApiCallAction;
    }

    /**
     * <p>
     * Information about the DNS_REQUEST action described in this finding.
     * </p>
     * 
     * @return Information about the DNS_REQUEST action described in this finding.
     */
    public DnsRequestAction dnsRequestAction() {
        return dnsRequestAction;
    }

    /**
     * <p>
     * Information about the NETWORK_CONNECTION action described in this finding.
     * </p>
     * 
     * @return Information about the NETWORK_CONNECTION action described in this finding.
     */
    public NetworkConnectionAction networkConnectionAction() {
        return networkConnectionAction;
    }

    /**
     * <p>
     * Information about the PORT_PROBE action described in this finding.
     * </p>
     * 
     * @return Information about the PORT_PROBE action described in this finding.
     */
    public PortProbeAction portProbeAction() {
        return portProbeAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(awsApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(dnsRequestAction());
        hashCode = 31 * hashCode + Objects.hashCode(networkConnectionAction());
        hashCode = 31 * hashCode + Objects.hashCode(portProbeAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(actionType(), other.actionType()) && Objects.equals(awsApiCallAction(), other.awsApiCallAction())
                && Objects.equals(dnsRequestAction(), other.dnsRequestAction())
                && Objects.equals(networkConnectionAction(), other.networkConnectionAction())
                && Objects.equals(portProbeAction(), other.portProbeAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Action").add("ActionType", actionType()).add("AwsApiCallAction", awsApiCallAction())
                .add("DnsRequestAction", dnsRequestAction()).add("NetworkConnectionAction", networkConnectionAction())
                .add("PortProbeAction", portProbeAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "AwsApiCallAction":
            return Optional.ofNullable(clazz.cast(awsApiCallAction()));
        case "DnsRequestAction":
            return Optional.ofNullable(clazz.cast(dnsRequestAction()));
        case "NetworkConnectionAction":
            return Optional.ofNullable(clazz.cast(networkConnectionAction()));
        case "PortProbeAction":
            return Optional.ofNullable(clazz.cast(portProbeAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * GuardDuty Finding activity type.
         * </p>
         * 
         * @param actionType
         *        GuardDuty Finding activity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Information about the AWS_API_CALL action described in this finding.
         * </p>
         * 
         * @param awsApiCallAction
         *        Information about the AWS_API_CALL action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsApiCallAction(AwsApiCallAction awsApiCallAction);

        /**
         * <p>
         * Information about the AWS_API_CALL action described in this finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsApiCallAction.Builder} avoiding the need to
         * create one manually via {@link AwsApiCallAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsApiCallAction.Builder#build()} is called immediately and its
         * result is passed to {@link #awsApiCallAction(AwsApiCallAction)}.
         * 
         * @param awsApiCallAction
         *        a consumer that will call methods on {@link AwsApiCallAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsApiCallAction(AwsApiCallAction)
         */
        default Builder awsApiCallAction(Consumer<AwsApiCallAction.Builder> awsApiCallAction) {
            return awsApiCallAction(AwsApiCallAction.builder().applyMutation(awsApiCallAction).build());
        }

        /**
         * <p>
         * Information about the DNS_REQUEST action described in this finding.
         * </p>
         * 
         * @param dnsRequestAction
         *        Information about the DNS_REQUEST action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRequestAction(DnsRequestAction dnsRequestAction);

        /**
         * <p>
         * Information about the DNS_REQUEST action described in this finding.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsRequestAction.Builder} avoiding the need to
         * create one manually via {@link DnsRequestAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsRequestAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsRequestAction(DnsRequestAction)}.
         * 
         * @param dnsRequestAction
         *        a consumer that will call methods on {@link DnsRequestAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsRequestAction(DnsRequestAction)
         */
        default Builder dnsRequestAction(Consumer<DnsRequestAction.Builder> dnsRequestAction) {
            return dnsRequestAction(DnsRequestAction.builder().applyMutation(dnsRequestAction).build());
        }

        /**
         * <p>
         * Information about the NETWORK_CONNECTION action described in this finding.
         * </p>
         * 
         * @param networkConnectionAction
         *        Information about the NETWORK_CONNECTION action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction);

        /**
         * <p>
         * Information about the NETWORK_CONNECTION action described in this finding.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConnectionAction.Builder} avoiding the
         * need to create one manually via {@link NetworkConnectionAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConnectionAction.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConnectionAction(NetworkConnectionAction)}.
         * 
         * @param networkConnectionAction
         *        a consumer that will call methods on {@link NetworkConnectionAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConnectionAction(NetworkConnectionAction)
         */
        default Builder networkConnectionAction(Consumer<NetworkConnectionAction.Builder> networkConnectionAction) {
            return networkConnectionAction(NetworkConnectionAction.builder().applyMutation(networkConnectionAction).build());
        }

        /**
         * <p>
         * Information about the PORT_PROBE action described in this finding.
         * </p>
         * 
         * @param portProbeAction
         *        Information about the PORT_PROBE action described in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portProbeAction(PortProbeAction portProbeAction);

        /**
         * <p>
         * Information about the PORT_PROBE action described in this finding.
         * </p>
         * This is a convenience that creates an instance of the {@link PortProbeAction.Builder} avoiding the need to
         * create one manually via {@link PortProbeAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortProbeAction.Builder#build()} is called immediately and its
         * result is passed to {@link #portProbeAction(PortProbeAction)}.
         * 
         * @param portProbeAction
         *        a consumer that will call methods on {@link PortProbeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portProbeAction(PortProbeAction)
         */
        default Builder portProbeAction(Consumer<PortProbeAction.Builder> portProbeAction) {
            return portProbeAction(PortProbeAction.builder().applyMutation(portProbeAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private AwsApiCallAction awsApiCallAction;

        private DnsRequestAction dnsRequestAction;

        private NetworkConnectionAction networkConnectionAction;

        private PortProbeAction portProbeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            actionType(model.actionType);
            awsApiCallAction(model.awsApiCallAction);
            dnsRequestAction(model.dnsRequestAction);
            networkConnectionAction(model.networkConnectionAction);
            portProbeAction(model.portProbeAction);
        }

        public final String getActionType() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final AwsApiCallAction.Builder getAwsApiCallAction() {
            return awsApiCallAction != null ? awsApiCallAction.toBuilder() : null;
        }

        @Override
        public final Builder awsApiCallAction(AwsApiCallAction awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction;
            return this;
        }

        public final void setAwsApiCallAction(AwsApiCallAction.BuilderImpl awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction != null ? awsApiCallAction.build() : null;
        }

        public final DnsRequestAction.Builder getDnsRequestAction() {
            return dnsRequestAction != null ? dnsRequestAction.toBuilder() : null;
        }

        @Override
        public final Builder dnsRequestAction(DnsRequestAction dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction;
            return this;
        }

        public final void setDnsRequestAction(DnsRequestAction.BuilderImpl dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction != null ? dnsRequestAction.build() : null;
        }

        public final NetworkConnectionAction.Builder getNetworkConnectionAction() {
            return networkConnectionAction != null ? networkConnectionAction.toBuilder() : null;
        }

        @Override
        public final Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction;
            return this;
        }

        public final void setNetworkConnectionAction(NetworkConnectionAction.BuilderImpl networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction != null ? networkConnectionAction.build() : null;
        }

        public final PortProbeAction.Builder getPortProbeAction() {
            return portProbeAction != null ? portProbeAction.toBuilder() : null;
        }

        @Override
        public final Builder portProbeAction(PortProbeAction portProbeAction) {
            this.portProbeAction = portProbeAction;
            return this;
        }

        public final void setPortProbeAction(PortProbeAction.BuilderImpl portProbeAction) {
            this.portProbeAction = portProbeAction != null ? portProbeAction.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
