/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Condition::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Condition::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> GT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Condition::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()).build();

    private static final SdkField<Integer> GTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Condition::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()).build();

    private static final SdkField<Integer> LT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Condition::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()).build();

    private static final SdkField<Integer> LTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Condition::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()).build();

    private static final SdkField<List<String>> EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Condition::equalsValue))
            .setter(setter(Builder::equalsValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Condition::notEquals))
            .setter(setter(Builder::notEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> GREATER_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Condition::greaterThan)).setter(setter(Builder::greaterThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<Long> GREATER_THAN_OR_EQUAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Condition::greaterThanOrEqual)).setter(setter(Builder::greaterThanOrEqual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEqual").build())
            .build();

    private static final SdkField<Long> LESS_THAN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Condition::lessThan)).setter(setter(Builder::lessThan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<Long> LESS_THAN_OR_EQUAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Condition::lessThanOrEqual)).setter(setter(Builder::lessThanOrEqual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEqual").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, NEQ_FIELD, GT_FIELD,
            GTE_FIELD, LT_FIELD, LTE_FIELD, EQUALS_FIELD, NOT_EQUALS_FIELD, GREATER_THAN_FIELD, GREATER_THAN_OR_EQUAL_FIELD,
            LESS_THAN_FIELD, LESS_THAN_OR_EQUAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final List<String> neq;

    private final Integer gt;

    private final Integer gte;

    private final Integer lt;

    private final Integer lte;

    private final List<String> equals;

    private final List<String> notEquals;

    private final Long greaterThan;

    private final Long greaterThanOrEqual;

    private final Long lessThan;

    private final Long lessThanOrEqual;

    private Condition(BuilderImpl builder) {
        this.eq = builder.eq;
        this.neq = builder.neq;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.equals = builder.equals;
        this.notEquals = builder.notEquals;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEqual = builder.greaterThanOrEqual;
        this.lessThan = builder.lessThan;
        this.lessThanOrEqual = builder.lessThanOrEqual;
    }

    /**
     * <p>
     * Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
     */
    public List<String> eq() {
        return eq;
    }

    /**
     * <p>
     * Deprecated. Represents the not equal condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Deprecated. Represents the not equal condition to be applied to a single field when querying for
     *         findings.
     */
    public List<String> neq() {
        return neq;
    }

    /**
     * <p>
     * Deprecated. Represents a greater than condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Deprecated. Represents a greater than condition to be applied to a single field when querying for
     *         findings.
     */
    public Integer gt() {
        return gt;
    }

    /**
     * <p>
     * Deprecated. Represents a greater than equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Deprecated. Represents a greater than equal condition to be applied to a single field when querying for
     *         findings.
     */
    public Integer gte() {
        return gte;
    }

    /**
     * <p>
     * Deprecated. Represents a less than condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Deprecated. Represents a less than condition to be applied to a single field when querying for findings.
     */
    public Integer lt() {
        return lt;
    }

    /**
     * <p>
     * Deprecated. Represents a less than equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Deprecated. Represents a less than equal condition to be applied to a single field when querying for
     *         findings.
     */
    public Integer lte() {
        return lte;
    }

    /**
     * <p>
     * Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
     */
    public List<String> equalsValue() {
        return equals;
    }

    /**
     * <p>
     * Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
     */
    public List<String> notEquals() {
        return notEquals;
    }

    /**
     * <p>
     * Represents a greater than condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a greater than condition to be applied to a single field when querying for findings.
     */
    public Long greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Represents a greater than equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a greater than equal condition to be applied to a single field when querying for findings.
     */
    public Long greaterThanOrEqual() {
        return greaterThanOrEqual;
    }

    /**
     * <p>
     * Represents a less than condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a less than condition to be applied to a single field when querying for findings.
     */
    public Long lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Represents a less than equal condition to be applied to a single field when querying for findings.
     * </p>
     * 
     * @return Represents a less than equal condition to be applied to a single field when querying for findings.
     */
    public Long lessThanOrEqual() {
        return lessThanOrEqual;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eq());
        hashCode = 31 * hashCode + Objects.hashCode(neq());
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(equalsValue());
        hashCode = 31 * hashCode + Objects.hashCode(notEquals());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEqual());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEqual());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(eq(), other.eq()) && Objects.equals(neq(), other.neq()) && Objects.equals(gt(), other.gt())
                && Objects.equals(gte(), other.gte()) && Objects.equals(lt(), other.lt()) && Objects.equals(lte(), other.lte())
                && Objects.equals(equalsValue(), other.equalsValue()) && Objects.equals(notEquals(), other.notEquals())
                && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEqual(), other.greaterThanOrEqual())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEqual(), other.lessThanOrEqual());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Condition").add("Eq", eq()).add("Neq", neq()).add("Gt", gt()).add("Gte", gte()).add("Lt", lt())
                .add("Lte", lte()).add("Equals", equalsValue()).add("NotEquals", notEquals()).add("GreaterThan", greaterThan())
                .add("GreaterThanOrEqual", greaterThanOrEqual()).add("LessThan", lessThan())
                .add("LessThanOrEqual", lessThanOrEqual()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "Neq":
            return Optional.ofNullable(clazz.cast(neq()));
        case "Gt":
            return Optional.ofNullable(clazz.cast(gt()));
        case "Gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "Lt":
            return Optional.ofNullable(clazz.cast(lt()));
        case "Lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "Equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        case "NotEquals":
            return Optional.ofNullable(clazz.cast(notEquals()));
        case "GreaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "GreaterThanOrEqual":
            return Optional.ofNullable(clazz.cast(greaterThanOrEqual()));
        case "LessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "LessThanOrEqual":
            return Optional.ofNullable(clazz.cast(lessThanOrEqual()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param eq
         *        Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param eq
         *        Deprecated. Represents the equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * Deprecated. Represents the not equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param neq
         *        Deprecated. Represents the not equal condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * Deprecated. Represents the not equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param neq
         *        Deprecated. Represents the not equal condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);

        /**
         * <p>
         * Deprecated. Represents a greater than condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param gt
         *        Deprecated. Represents a greater than condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(Integer gt);

        /**
         * <p>
         * Deprecated. Represents a greater than equal condition to be applied to a single field when querying for
         * findings.
         * </p>
         * 
         * @param gte
         *        Deprecated. Represents a greater than equal condition to be applied to a single field when querying
         *        for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gte(Integer gte);

        /**
         * <p>
         * Deprecated. Represents a less than condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lt
         *        Deprecated. Represents a less than condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(Integer lt);

        /**
         * <p>
         * Deprecated. Represents a less than equal condition to be applied to a single field when querying for
         * findings.
         * </p>
         * 
         * @param lte
         *        Deprecated. Represents a less than equal condition to be applied to a single field when querying for
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Integer lte);

        /**
         * <p>
         * Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param equals
         *        Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(Collection<String> equals);

        /**
         * <p>
         * Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param equals
         *        Represents an <b>equal</b> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(String... equals);

        /**
         * <p>
         * Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param notEquals
         *        Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(Collection<String> notEquals);

        /**
         * <p>
         * Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param notEquals
         *        Represents an <b>not equal</b> condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notEquals(String... notEquals);

        /**
         * <p>
         * Represents a greater than condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param greaterThan
         *        Represents a greater than condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(Long greaterThan);

        /**
         * <p>
         * Represents a greater than equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param greaterThanOrEqual
         *        Represents a greater than equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEqual(Long greaterThanOrEqual);

        /**
         * <p>
         * Represents a less than condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lessThan
         *        Represents a less than condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(Long lessThan);

        /**
         * <p>
         * Represents a less than equal condition to be applied to a single field when querying for findings.
         * </p>
         * 
         * @param lessThanOrEqual
         *        Represents a less than equal condition to be applied to a single field when querying for findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEqual(Long lessThanOrEqual);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private Integer gt;

        private Integer gte;

        private Integer lt;

        private Integer lte;

        private List<String> equals = DefaultSdkAutoConstructList.getInstance();

        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();

        private Long greaterThan;

        private Long greaterThanOrEqual;

        private Long lessThan;

        private Long lessThanOrEqual;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            eq(model.eq);
            neq(model.neq);
            gt(model.gt);
            gte(model.gte);
            lt(model.lt);
            lte(model.lte);
            equalsValue(model.equals);
            notEquals(model.notEquals);
            greaterThan(model.greaterThan);
            greaterThanOrEqual(model.greaterThanOrEqual);
            lessThan(model.lessThan);
            lessThanOrEqual(model.lessThanOrEqual);
        }

        public final Collection<String> getEq() {
            return eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
        }

        public final Collection<String> getNeq() {
            return neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
        }

        public final Integer getGt() {
            return gt;
        }

        @Override
        public final Builder gt(Integer gt) {
            this.gt = gt;
            return this;
        }

        public final void setGt(Integer gt) {
            this.gt = gt;
        }

        public final Integer getGte() {
            return gte;
        }

        @Override
        public final Builder gte(Integer gte) {
            this.gte = gte;
            return this;
        }

        public final void setGte(Integer gte) {
            this.gte = gte;
        }

        public final Integer getLt() {
            return lt;
        }

        @Override
        public final Builder lt(Integer lt) {
            this.lt = lt;
            return this;
        }

        public final void setLt(Integer lt) {
            this.lt = lt;
        }

        public final Integer getLte() {
            return lte;
        }

        @Override
        public final Builder lte(Integer lte) {
            this.lte = lte;
            return this;
        }

        public final void setLte(Integer lte) {
            this.lte = lte;
        }

        public final Collection<String> getEqualsValue() {
            return equals;
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String... equals) {
            equalsValue(Arrays.asList(equals));
            return this;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
        }

        public final Collection<String> getNotEquals() {
            return notEquals;
        }

        @Override
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEquals(String... notEquals) {
            notEquals(Arrays.asList(notEquals));
            return this;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
        }

        public final Long getGreaterThan() {
            return greaterThan;
        }

        @Override
        public final Builder greaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        public final void setGreaterThan(Long greaterThan) {
            this.greaterThan = greaterThan;
        }

        public final Long getGreaterThanOrEqual() {
            return greaterThanOrEqual;
        }

        @Override
        public final Builder greaterThanOrEqual(Long greaterThanOrEqual) {
            this.greaterThanOrEqual = greaterThanOrEqual;
            return this;
        }

        public final void setGreaterThanOrEqual(Long greaterThanOrEqual) {
            this.greaterThanOrEqual = greaterThanOrEqual;
        }

        public final Long getLessThan() {
            return lessThan;
        }

        @Override
        public final Builder lessThan(Long lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        public final void setLessThan(Long lessThan) {
            this.lessThan = lessThan;
        }

        public final Long getLessThanOrEqual() {
            return lessThanOrEqual;
        }

        @Override
        public final Builder lessThanOrEqual(Long lessThanOrEqual) {
            this.lessThanOrEqual = lessThanOrEqual;
            return this;
        }

        public final void setLessThanOrEqual(Long lessThanOrEqual) {
            this.lessThanOrEqual = lessThanOrEqual;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
