/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InviteMembersRequest extends GuardDutyRequest implements
        ToCopyableBuilder<InviteMembersRequest.Builder, InviteMembersRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InviteMembersRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InviteMembersRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_EMAIL_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(InviteMembersRequest::disableEmailNotification)).setter(setter(Builder::disableEmailNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableEmailNotification").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InviteMembersRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            ACCOUNT_IDS_FIELD, DISABLE_EMAIL_NOTIFICATION_FIELD, MESSAGE_FIELD));

    private final String detectorId;

    private final List<String> accountIds;

    private final Boolean disableEmailNotification;

    private final String message;

    private InviteMembersRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.accountIds = builder.accountIds;
        this.disableEmailNotification = builder.disableEmailNotification;
        this.message = builder.message;
    }

    /**
     * <p>
     * The unique ID of the detector of the GuardDuty account with which you want to invite members.
     * </p>
     * 
     * @return The unique ID of the detector of the GuardDuty account with which you want to invite members.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * A list of account IDs of the accounts that you want to invite to GuardDuty as members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of account IDs of the accounts that you want to invite to GuardDuty as members.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * A boolean value that specifies whether you want to disable email notification to the accounts that you’re
     * inviting to GuardDuty as members.
     * </p>
     * 
     * @return A boolean value that specifies whether you want to disable email notification to the accounts that you’re
     *         inviting to GuardDuty as members.
     */
    public Boolean disableEmailNotification() {
        return disableEmailNotification;
    }

    /**
     * <p>
     * The invitation message that you want to send to the accounts that you’re inviting to GuardDuty as members.
     * </p>
     * 
     * @return The invitation message that you want to send to the accounts that you’re inviting to GuardDuty as
     *         members.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(disableEmailNotification());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteMembersRequest)) {
            return false;
        }
        InviteMembersRequest other = (InviteMembersRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(disableEmailNotification(), other.disableEmailNotification())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InviteMembersRequest").add("DetectorId", detectorId()).add("AccountIds", accountIds())
                .add("DisableEmailNotification", disableEmailNotification()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "DisableEmailNotification":
            return Optional.ofNullable(clazz.cast(disableEmailNotification()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteMembersRequest, T> g) {
        return obj -> g.apply((InviteMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, InviteMembersRequest> {
        /**
         * <p>
         * The unique ID of the detector of the GuardDuty account with which you want to invite members.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector of the GuardDuty account with which you want to invite members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * A list of account IDs of the accounts that you want to invite to GuardDuty as members.
         * </p>
         * 
         * @param accountIds
         *        A list of account IDs of the accounts that you want to invite to GuardDuty as members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * A list of account IDs of the accounts that you want to invite to GuardDuty as members.
         * </p>
         * 
         * @param accountIds
         *        A list of account IDs of the accounts that you want to invite to GuardDuty as members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * A boolean value that specifies whether you want to disable email notification to the accounts that you’re
         * inviting to GuardDuty as members.
         * </p>
         * 
         * @param disableEmailNotification
         *        A boolean value that specifies whether you want to disable email notification to the accounts that
         *        you’re inviting to GuardDuty as members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableEmailNotification(Boolean disableEmailNotification);

        /**
         * <p>
         * The invitation message that you want to send to the accounts that you’re inviting to GuardDuty as members.
         * </p>
         * 
         * @param message
         *        The invitation message that you want to send to the accounts that you’re inviting to GuardDuty as
         *        members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean disableEmailNotification;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteMembersRequest model) {
            super(model);
            detectorId(model.detectorId);
            accountIds(model.accountIds);
            disableEmailNotification(model.disableEmailNotification);
            message(model.message);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final Boolean getDisableEmailNotification() {
            return disableEmailNotification;
        }

        @Override
        public final Builder disableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        public final void setDisableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InviteMembersRequest build() {
            return new InviteMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
