/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the port for the local connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LocalPortDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LocalPortDetails.Builder, LocalPortDetails> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(LocalPortDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LocalPortDetails::portName)).setter(setter(Builder::portName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, PORT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String portName;

    private LocalPortDetails(BuilderImpl builder) {
        this.port = builder.port;
        this.portName = builder.portName;
    }

    /**
     * <p>
     * Port number of the local connection.
     * </p>
     * 
     * @return Port number of the local connection.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * Port name of the local connection.
     * </p>
     * 
     * @return Port name of the local connection.
     */
    public String portName() {
        return portName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(portName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalPortDetails)) {
            return false;
        }
        LocalPortDetails other = (LocalPortDetails) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(portName(), other.portName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LocalPortDetails").add("Port", port()).add("PortName", portName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "PortName":
            return Optional.ofNullable(clazz.cast(portName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocalPortDetails, T> g) {
        return obj -> g.apply((LocalPortDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LocalPortDetails> {
        /**
         * <p>
         * Port number of the local connection.
         * </p>
         * 
         * @param port
         *        Port number of the local connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Port name of the local connection.
         * </p>
         * 
         * @param portName
         *        Port name of the local connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portName(String portName);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String portName;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalPortDetails model) {
            port(model.port);
            portName(model.portName);
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getPortName() {
            return portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public LocalPortDetails build() {
            return new LocalPortDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
