/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventAccountFilter;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model.OrganizationEntityFiltersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAffectedEntitiesForOrganizationRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_ENTITY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::organizationEntityFilters)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::organizationEntityFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEntityFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventAccountFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::locale)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::nextToken)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeAffectedEntitiesForOrganizationRequest.getter(DescribeAffectedEntitiesForOrganizationRequest::maxResults)).setter(DescribeAffectedEntitiesForOrganizationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ENTITY_FILTERS_FIELD, LOCALE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<EventAccountFilter> organizationEntityFilters;
    private final String locale;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeAffectedEntitiesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEntityFilters = builder.organizationEntityFilters;
        this.locale = builder.locale;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasOrganizationEntityFilters() {
        return this.organizationEntityFilters != null && !(this.organizationEntityFilters instanceof SdkAutoConstructList);
    }

    public List<EventAccountFilter> organizationEntityFilters() {
        return this.organizationEntityFilters;
    }

    public String locale() {
        return this.locale;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationEntityFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationRequest)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationRequest other = (DescribeAffectedEntitiesForOrganizationRequest)((Object)obj);
        return Objects.equals(this.organizationEntityFilters(), other.organizationEntityFilters()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAffectedEntitiesForOrganizationRequest").add("OrganizationEntityFilters", this.organizationEntityFilters()).add("Locale", (Object)this.locale()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "organizationEntityFilters": {
                return Optional.ofNullable(clazz.cast(this.organizationEntityFilters()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<EventAccountFilter> organizationEntityFilters = DefaultSdkAutoConstructList.getInstance();
        private String locale;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationRequest model) {
            super(model);
            this.organizationEntityFilters(model.organizationEntityFilters);
            this.locale(model.locale);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<EventAccountFilter.Builder> getOrganizationEntityFilters() {
            return this.organizationEntityFilters != null ? (Collection)this.organizationEntityFilters.stream().map(EventAccountFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationEntityFilters(Collection<EventAccountFilter> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copy(organizationEntityFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityFilters(EventAccountFilter ... organizationEntityFilters) {
            this.organizationEntityFilters(Arrays.asList(organizationEntityFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder> ... organizationEntityFilters) {
            this.organizationEntityFilters(Stream.of(organizationEntityFilters).map(c -> (EventAccountFilter)((EventAccountFilter.Builder)EventAccountFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationEntityFilters(Collection<EventAccountFilter.BuilderImpl> organizationEntityFilters) {
            this.organizationEntityFilters = OrganizationEntityFiltersListCopier.copyFromBuilder(organizationEntityFilters);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationRequest build() {
            return new DescribeAffectedEntitiesForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationRequest> {
        public Builder organizationEntityFilters(Collection<EventAccountFilter> var1);

        public Builder organizationEntityFilters(EventAccountFilter ... var1);

        public Builder organizationEntityFilters(Consumer<EventAccountFilter.Builder> ... var1);

        public Builder locale(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

