/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEntityAggregatesResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEntityAggregatesResponse.Builder, DescribeEntityAggregatesResponse> {
    private static final SdkField<List<EntityAggregate>> ENTITY_AGGREGATES_FIELD = SdkField
            .<List<EntityAggregate>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEntityAggregatesResponse::entityAggregates))
            .setter(setter(Builder::entityAggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityAggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_AGGREGATES_FIELD));

    private final List<EntityAggregate> entityAggregates;

    private DescribeEntityAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.entityAggregates = builder.entityAggregates;
    }

    /**
     * Returns true if the EntityAggregates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEntityAggregates() {
        return entityAggregates != null && !(entityAggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of entities that are affected by each of the specified events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityAggregates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The number of entities that are affected by each of the specified events.
     */
    public List<EntityAggregate> entityAggregates() {
        return entityAggregates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityAggregates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesResponse)) {
            return false;
        }
        DescribeEntityAggregatesResponse other = (DescribeEntityAggregatesResponse) obj;
        return Objects.equals(entityAggregates(), other.entityAggregates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEntityAggregatesResponse").add("EntityAggregates", entityAggregates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityAggregates":
            return Optional.ofNullable(clazz.cast(entityAggregates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * 
         * @param entityAggregates
         *        The number of entities that are affected by each of the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityAggregates(Collection<EntityAggregate> entityAggregates);

        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * 
         * @param entityAggregates
         *        The number of entities that are affected by each of the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityAggregates(EntityAggregate... entityAggregates);

        /**
         * <p>
         * The number of entities that are affected by each of the specified events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityAggregate>.Builder} avoiding the need
         * to create one manually via {@link List<EntityAggregate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityAggregate>.Builder#build()} is called immediately and
         * its result is passed to {@link #entityAggregates(List<EntityAggregate>)}.
         * 
         * @param entityAggregates
         *        a consumer that will call methods on {@link List<EntityAggregate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityAggregates(List<EntityAggregate>)
         */
        Builder entityAggregates(Consumer<EntityAggregate.Builder>... entityAggregates);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EntityAggregate> entityAggregates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesResponse model) {
            super(model);
            entityAggregates(model.entityAggregates);
        }

        public final Collection<EntityAggregate.Builder> getEntityAggregates() {
            return entityAggregates != null ? entityAggregates.stream().map(EntityAggregate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityAggregates(Collection<EntityAggregate> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copy(entityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(EntityAggregate... entityAggregates) {
            entityAggregates(Arrays.asList(entityAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(Consumer<EntityAggregate.Builder>... entityAggregates) {
            entityAggregates(Stream.of(entityAggregates).map(c -> EntityAggregate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEntityAggregates(Collection<EntityAggregate.BuilderImpl> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copyFromBuilder(entityAggregates);
        }

        @Override
        public DescribeEntityAggregatesResponse build() {
            return new DescribeEntityAggregatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
