/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values to use to filter results from the <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> and <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html"
 * >DescribeEventAggregates</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventFilter.Builder, EventFilter> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::eventArns))
            .setter(setter(Builder::eventArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::eventTypeCodes))
            .setter(setter(Builder::eventTypeCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> START_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::startTimes))
            .setter(setter(Builder::startTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> END_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::endTimes))
            .setter(setter(Builder::endTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DateTimeRange>> LAST_UPDATED_TIMES_FIELD = SdkField
            .<List<DateTimeRange>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::lastUpdatedTimes))
            .setter(setter(Builder::lastUpdatedTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(DateTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::entityArns))
            .setter(setter(Builder::entityArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::entityValues))
            .setter(setter(Builder::entityValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::eventTypeCategoriesAsStrings))
            .setter(setter(Builder::eventTypeCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> TAGS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(EventFilter::eventStatusCodesAsStrings))
            .setter(setter(Builder::eventStatusCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD,
            EVENT_TYPE_CODES_FIELD, SERVICES_FIELD, REGIONS_FIELD, AVAILABILITY_ZONES_FIELD, START_TIMES_FIELD, END_TIMES_FIELD,
            LAST_UPDATED_TIMES_FIELD, ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, TAGS_FIELD,
            EVENT_STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventArns;

    private final List<String> eventTypeCodes;

    private final List<String> services;

    private final List<String> regions;

    private final List<String> availabilityZones;

    private final List<DateTimeRange> startTimes;

    private final List<DateTimeRange> endTimes;

    private final List<DateTimeRange> lastUpdatedTimes;

    private final List<String> entityArns;

    private final List<String> entityValues;

    private final List<String> eventTypeCategories;

    private final List<Map<String, String>> tags;

    private final List<String> eventStatusCodes;

    private EventFilter(BuilderImpl builder) {
        this.eventArns = builder.eventArns;
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.regions = builder.regions;
        this.availabilityZones = builder.availabilityZones;
        this.startTimes = builder.startTimes;
        this.endTimes = builder.endTimes;
        this.lastUpdatedTimes = builder.lastUpdatedTimes;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.tags = builder.tags;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    /**
     * Returns true if the EventArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventArns() {
        return eventArns != null && !(eventArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event ARNs (unique identifiers). For example:
     * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event ARNs (unique identifiers). For example:
     *         <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
     */
    public List<String> eventArns() {
        return eventArns;
    }

    /**
     * Returns true if the EventTypeCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventTypeCodes() {
        return eventTypeCodes != null && !(eventTypeCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers for event types. For example,
     * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTypeCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unique identifiers for event types. For example,
     *         <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     */
    public List<String> eventTypeCodes() {
        return eventTypeCodes;
    }

    /**
     * Returns true if the Services property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     */
    public List<String> services() {
        return services;
    }

    /**
     * Returns true if the Regions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS regions.
     */
    public List<String> regions() {
        return regions;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS availability zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS availability zones.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the StartTimes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStartTimes() {
        return startTimes != null && !(startTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event began.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStartTimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dates and times that the event began.
     */
    public List<DateTimeRange> startTimes() {
        return startTimes;
    }

    /**
     * Returns true if the EndTimes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEndTimes() {
        return endTimes != null && !(endTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event ended.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndTimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dates and times that the event ended.
     */
    public List<DateTimeRange> endTimes() {
        return endTimes;
    }

    /**
     * Returns true if the LastUpdatedTimes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLastUpdatedTimes() {
        return lastUpdatedTimes != null && !(lastUpdatedTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dates and times that the event was last updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLastUpdatedTimes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dates and times that the event was last updated.
     */
    public List<DateTimeRange> lastUpdatedTimes() {
        return lastUpdatedTimes;
    }

    /**
     * Returns true if the EntityArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityArns() {
        return entityArns != null && !(entityArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity ARNs (unique identifiers).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of entity ARNs (unique identifiers).
     */
    public List<String> entityArns() {
        return entityArns;
    }

    /**
     * Returns true if the EntityValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityValues() {
        return entityValues != null && !(entityValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
     * <code>vol-426ab23e</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
     *         <code>vol-426ab23e</code>).
     */
    public List<String> entityValues() {
        return entityValues;
    }

    /**
     * <p>
     * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     * <code>accountNotification</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTypeCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     *         <code>accountNotification</code>).
     */
    public List<EventTypeCategory> eventTypeCategories() {
        return _eventTypeCategoryListCopier.copyStringToEnum(eventTypeCategories);
    }

    /**
     * Returns true if the EventTypeCategories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventTypeCategories() {
        return eventTypeCategories != null && !(eventTypeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     * <code>accountNotification</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTypeCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     *         <code>accountNotification</code>).
     */
    public List<String> eventTypeCategoriesAsStrings() {
        return eventTypeCategories;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of entity tags attached to the affected entity.
     * </p>
     * <note>
     * <p>
     * Currently, the <code>tags</code> property isn't supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of entity tags attached to the affected entity.</p> <note>
     *         <p>
     *         Currently, the <code>tags</code> property isn't supported.
     *         </p>
     */
    public List<Map<String, String>> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventStatusCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public List<EventStatusCode> eventStatusCodes() {
        return _eventStatusCodeListCopier.copyStringToEnum(eventStatusCodes);
    }

    /**
     * Returns true if the EventStatusCodes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventStatusCodes() {
        return eventStatusCodes != null && !(eventStatusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventStatusCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public List<String> eventStatusCodesAsStrings() {
        return eventStatusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventArns());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeCodes());
        hashCode = 31 * hashCode + Objects.hashCode(services());
        hashCode = 31 * hashCode + Objects.hashCode(regions());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(startTimes());
        hashCode = 31 * hashCode + Objects.hashCode(endTimes());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(entityArns());
        hashCode = 31 * hashCode + Objects.hashCode(entityValues());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeCategoriesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusCodesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter) obj;
        return Objects.equals(eventArns(), other.eventArns()) && Objects.equals(eventTypeCodes(), other.eventTypeCodes())
                && Objects.equals(services(), other.services()) && Objects.equals(regions(), other.regions())
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(startTimes(), other.startTimes()) && Objects.equals(endTimes(), other.endTimes())
                && Objects.equals(lastUpdatedTimes(), other.lastUpdatedTimes())
                && Objects.equals(entityArns(), other.entityArns()) && Objects.equals(entityValues(), other.entityValues())
                && Objects.equals(eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings())
                && Objects.equals(tags(), other.tags())
                && Objects.equals(eventStatusCodesAsStrings(), other.eventStatusCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventFilter").add("EventArns", eventArns()).add("EventTypeCodes", eventTypeCodes())
                .add("Services", services()).add("Regions", regions()).add("AvailabilityZones", availabilityZones())
                .add("StartTimes", startTimes()).add("EndTimes", endTimes()).add("LastUpdatedTimes", lastUpdatedTimes())
                .add("EntityArns", entityArns()).add("EntityValues", entityValues())
                .add("EventTypeCategories", eventTypeCategoriesAsStrings()).add("Tags", tags())
                .add("EventStatusCodes", eventStatusCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventArns":
            return Optional.ofNullable(clazz.cast(eventArns()));
        case "eventTypeCodes":
            return Optional.ofNullable(clazz.cast(eventTypeCodes()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "availabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "startTimes":
            return Optional.ofNullable(clazz.cast(startTimes()));
        case "endTimes":
            return Optional.ofNullable(clazz.cast(endTimes()));
        case "lastUpdatedTimes":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimes()));
        case "entityArns":
            return Optional.ofNullable(clazz.cast(entityArns()));
        case "entityValues":
            return Optional.ofNullable(clazz.cast(entityValues()));
        case "eventTypeCategories":
            return Optional.ofNullable(clazz.cast(eventTypeCategoriesAsStrings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "eventStatusCodes":
            return Optional.ofNullable(clazz.cast(eventStatusCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFilter> {
        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(Collection<String> eventArns);

        /**
         * <p>
         * A list of event ARNs (unique identifiers). For example:
         * <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * </p>
         * 
         * @param eventArns
         *        A list of event ARNs (unique identifiers). For example:
         *        <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArns(String... eventArns);

        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(Collection<String> eventTypeCodes);

        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(String... eventTypeCodes);

        /**
         * <p>
         * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);

        /**
         * <p>
         * A list of AWS regions.
         * </p>
         * 
         * @param regions
         *        A list of AWS regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * A list of AWS regions.
         * </p>
         * 
         * @param regions
         *        A list of AWS regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * A list of AWS availability zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of AWS availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of AWS availability zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of AWS availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * 
         * @param startTimes
         *        A list of dates and times that the event began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimes(Collection<DateTimeRange> startTimes);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * 
         * @param startTimes
         *        A list of dates and times that the event began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimes(DateTimeRange... startTimes);

        /**
         * <p>
         * A list of dates and times that the event began.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeRange>.Builder} avoiding the need
         * to create one manually via {@link List<DateTimeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeRange>.Builder#build()} is called immediately and
         * its result is passed to {@link #startTimes(List<DateTimeRange>)}.
         * 
         * @param startTimes
         *        a consumer that will call methods on {@link List<DateTimeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimes(List<DateTimeRange>)
         */
        Builder startTimes(Consumer<DateTimeRange.Builder>... startTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * 
         * @param endTimes
         *        A list of dates and times that the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(Collection<DateTimeRange> endTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * 
         * @param endTimes
         *        A list of dates and times that the event ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimes(DateTimeRange... endTimes);

        /**
         * <p>
         * A list of dates and times that the event ended.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeRange>.Builder} avoiding the need
         * to create one manually via {@link List<DateTimeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeRange>.Builder#build()} is called immediately and
         * its result is passed to {@link #endTimes(List<DateTimeRange>)}.
         * 
         * @param endTimes
         *        a consumer that will call methods on {@link List<DateTimeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTimes(List<DateTimeRange>)
         */
        Builder endTimes(Consumer<DateTimeRange.Builder>... endTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of dates and times that the event was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * 
         * @param lastUpdatedTimes
         *        A list of dates and times that the event was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes);

        /**
         * <p>
         * A list of dates and times that the event was last updated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DateTimeRange>.Builder} avoiding the need
         * to create one manually via {@link List<DateTimeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DateTimeRange>.Builder#build()} is called immediately and
         * its result is passed to {@link #lastUpdatedTimes(List<DateTimeRange>)}.
         * 
         * @param lastUpdatedTimes
         *        a consumer that will call methods on {@link List<DateTimeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdatedTimes(List<DateTimeRange>)
         */
        Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(Collection<String> entityArns);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(String... entityArns);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         * <code>vol-426ab23e</code>).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         *        <code>vol-426ab23e</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(Collection<String> entityValues);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         * <code>vol-426ab23e</code>).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS volumes (
         *        <code>vol-426ab23e</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(String... entityValues);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(String... eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(EventTypeCategory... eventTypeCategories);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<? extends Map<String, String>> tags);

        /**
         * <p>
         * A map of entity tags attached to the affected entity.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>tags</code> property isn't supported.
         * </p>
         * </note>
         * 
         * @param tags
         *        A map of entity tags attached to the affected entity.</p> <note>
         *        <p>
         *        Currently, the <code>tags</code> property isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String>... tags);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(String... eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(EventStatusCode... eventStatusCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> startTimes = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> endTimes = DefaultSdkAutoConstructList.getInstance();

        private List<DateTimeRange> lastUpdatedTimes = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, String>> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            eventArns(model.eventArns);
            eventTypeCodes(model.eventTypeCodes);
            services(model.services);
            regions(model.regions);
            availabilityZones(model.availabilityZones);
            startTimes(model.startTimes);
            endTimes(model.endTimes);
            lastUpdatedTimes(model.lastUpdatedTimes);
            entityArns(model.entityArns);
            entityValues(model.entityValues);
            eventTypeCategoriesWithStrings(model.eventTypeCategories);
            tags(model.tags);
            eventStatusCodesWithStrings(model.eventStatusCodes);
        }

        public final Collection<String> getEventArns() {
            return eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String... eventArns) {
            eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final Collection<String> getEventTypeCodes() {
            return eventTypeCodes;
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String... eventTypeCodes) {
            eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        public final Collection<String> getServices() {
            return services;
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        public final Collection<String> getRegions() {
            return regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = _availabilityZonesCopier.copy(availabilityZones);
        }

        public final Collection<DateTimeRange.Builder> getStartTimes() {
            return startTimes != null ? startTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startTimes(Collection<DateTimeRange> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copy(startTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(DateTimeRange... startTimes) {
            startTimes(Arrays.asList(startTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startTimes(Consumer<DateTimeRange.Builder>... startTimes) {
            startTimes(Stream.of(startTimes).map(c -> DateTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStartTimes(Collection<DateTimeRange.BuilderImpl> startTimes) {
            this.startTimes = _dateTimeRangeListCopier.copyFromBuilder(startTimes);
        }

        public final Collection<DateTimeRange.Builder> getEndTimes() {
            return endTimes != null ? endTimes.stream().map(DateTimeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endTimes(Collection<DateTimeRange> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copy(endTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(DateTimeRange... endTimes) {
            endTimes(Arrays.asList(endTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endTimes(Consumer<DateTimeRange.Builder>... endTimes) {
            endTimes(Stream.of(endTimes).map(c -> DateTimeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndTimes(Collection<DateTimeRange.BuilderImpl> endTimes) {
            this.endTimes = _dateTimeRangeListCopier.copyFromBuilder(endTimes);
        }

        public final Collection<DateTimeRange.Builder> getLastUpdatedTimes() {
            return lastUpdatedTimes != null ? lastUpdatedTimes.stream().map(DateTimeRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copy(lastUpdatedTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(DateTimeRange... lastUpdatedTimes) {
            lastUpdatedTimes(Arrays.asList(lastUpdatedTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastUpdatedTimes(Consumer<DateTimeRange.Builder>... lastUpdatedTimes) {
            lastUpdatedTimes(Stream.of(lastUpdatedTimes).map(c -> DateTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLastUpdatedTimes(Collection<DateTimeRange.BuilderImpl> lastUpdatedTimes) {
            this.lastUpdatedTimes = _dateTimeRangeListCopier.copyFromBuilder(lastUpdatedTimes);
        }

        public final Collection<String> getEntityArns() {
            return entityArns;
        }

        @Override
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityArns(String... entityArns) {
            entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        public final Collection<String> getEntityValues() {
            return entityValues;
        }

        @Override
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityValues(String... entityValues) {
            entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        public final Collection<String> getEventTypeCategories() {
            return eventTypeCategories;
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String... eventTypeCategories) {
            eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory... eventTypeCategories) {
            eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        public final Collection<? extends Map<String, String>> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Map<String, String>... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<? extends Map<String, String>> tags) {
            this.tags = _tagFilterCopier.copy(tags);
        }

        public final Collection<String> getEventStatusCodes() {
            return eventStatusCodes;
        }

        @Override
        public final Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodesWithStrings(String... eventStatusCodes) {
            eventStatusCodesWithStrings(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public final Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copyEnumToString(eventStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode... eventStatusCodes) {
            eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
