/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EntityAggregate;
import software.amazon.awssdk.services.health.model.EntityAggregateListCopier;
import software.amazon.awssdk.services.health.model.HealthResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityAggregatesResponse
extends HealthResponse
implements ToCopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
    private static final SdkField<List<EntityAggregate>> ENTITY_AGGREGATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeEntityAggregatesResponse.getter(DescribeEntityAggregatesResponse::entityAggregates)).setter(DescribeEntityAggregatesResponse.setter(Builder::entityAggregates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityAggregates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityAggregate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_AGGREGATES_FIELD));
    private final List<EntityAggregate> entityAggregates;

    private DescribeEntityAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.entityAggregates = builder.entityAggregates;
    }

    public boolean hasEntityAggregates() {
        return this.entityAggregates != null && !(this.entityAggregates instanceof SdkAutoConstructList);
    }

    public List<EntityAggregate> entityAggregates() {
        return this.entityAggregates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityAggregates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityAggregatesResponse)) {
            return false;
        }
        DescribeEntityAggregatesResponse other = (DescribeEntityAggregatesResponse)((Object)obj);
        return Objects.equals(this.entityAggregates(), other.entityAggregates());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEntityAggregatesResponse").add("EntityAggregates", this.entityAggregates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityAggregates": {
                return Optional.ofNullable(clazz.cast(this.entityAggregates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEntityAggregatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthResponse.BuilderImpl
    implements Builder {
        private List<EntityAggregate> entityAggregates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityAggregatesResponse model) {
            super(model);
            this.entityAggregates(model.entityAggregates);
        }

        public final Collection<EntityAggregate.Builder> getEntityAggregates() {
            return this.entityAggregates != null ? (Collection)this.entityAggregates.stream().map(EntityAggregate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entityAggregates(Collection<EntityAggregate> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copy(entityAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(EntityAggregate ... entityAggregates) {
            this.entityAggregates(Arrays.asList(entityAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityAggregates(Consumer<EntityAggregate.Builder> ... entityAggregates) {
            this.entityAggregates(Stream.of(entityAggregates).map(c -> (EntityAggregate)((EntityAggregate.Builder)EntityAggregate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntityAggregates(Collection<EntityAggregate.BuilderImpl> entityAggregates) {
            this.entityAggregates = EntityAggregateListCopier.copyFromBuilder(entityAggregates);
        }

        @Override
        public DescribeEntityAggregatesResponse build() {
            return new DescribeEntityAggregatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityAggregatesResponse> {
        public Builder entityAggregates(Collection<EntityAggregate> var1);

        public Builder entityAggregates(EntityAggregate ... var1);

        public Builder entityAggregates(Consumer<EntityAggregate.Builder> ... var1);
    }
}

