/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventAggregatesResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEventAggregatesResponse.Builder, DescribeEventAggregatesResponse> {
    private static final SdkField<List<EventAggregate>> EVENT_AGGREGATES_FIELD = SdkField
            .<List<EventAggregate>> builder(MarshallingType.LIST)
            .memberName("eventAggregates")
            .getter(getter(DescribeEventAggregatesResponse::eventAggregates))
            .setter(setter(Builder::eventAggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEventAggregatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_AGGREGATES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventAggregate> eventAggregates;

    private final String nextToken;

    private DescribeEventAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.eventAggregates = builder.eventAggregates;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventAggregates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventAggregates() {
        return eventAggregates != null && !(eventAggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of events in each category that meet the optional filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventAggregates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The number of events in each category that meet the optional filter criteria.
     */
    public List<EventAggregate> eventAggregates() {
        return eventAggregates;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventAggregates() ? eventAggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesResponse)) {
            return false;
        }
        DescribeEventAggregatesResponse other = (DescribeEventAggregatesResponse) obj;
        return hasEventAggregates() == other.hasEventAggregates() && Objects.equals(eventAggregates(), other.eventAggregates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventAggregatesResponse")
                .add("EventAggregates", hasEventAggregates() ? eventAggregates() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventAggregates":
            return Optional.ofNullable(clazz.cast(eventAggregates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEventAggregatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventAggregatesResponse> {
        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * 
         * @param eventAggregates
         *        The number of events in each category that meet the optional filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAggregates(Collection<EventAggregate> eventAggregates);

        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * 
         * @param eventAggregates
         *        The number of events in each category that meet the optional filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAggregates(EventAggregate... eventAggregates);

        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventAggregate>.Builder} avoiding the need
         * to create one manually via {@link List<EventAggregate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventAggregate>.Builder#build()} is called immediately and
         * its result is passed to {@link #eventAggregates(List<EventAggregate>)}.
         * 
         * @param eventAggregates
         *        a consumer that will call methods on {@link List<EventAggregate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventAggregates(List<EventAggregate>)
         */
        Builder eventAggregates(Consumer<EventAggregate.Builder>... eventAggregates);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EventAggregate> eventAggregates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesResponse model) {
            super(model);
            eventAggregates(model.eventAggregates);
            nextToken(model.nextToken);
        }

        public final Collection<EventAggregate.Builder> getEventAggregates() {
            if (eventAggregates instanceof SdkAutoConstructList) {
                return null;
            }
            return eventAggregates != null ? eventAggregates.stream().map(EventAggregate::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder eventAggregates(Collection<EventAggregate> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copy(eventAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(EventAggregate... eventAggregates) {
            eventAggregates(Arrays.asList(eventAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(Consumer<EventAggregate.Builder>... eventAggregates) {
            eventAggregates(Stream.of(eventAggregates).map(c -> EventAggregate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEventAggregates(Collection<EventAggregate.BuilderImpl> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copyFromBuilder(eventAggregates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventAggregatesResponse build() {
            return new DescribeEventAggregatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
