/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventTypesResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEventTypesResponse.Builder, DescribeEventTypesResponse> {
    private static final SdkField<List<EventType>> EVENT_TYPES_FIELD = SdkField
            .<List<EventType>> builder(MarshallingType.LIST)
            .memberName("eventTypes")
            .getter(getter(DescribeEventTypesResponse::eventTypes))
            .setter(setter(Builder::eventTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventType> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEventTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EventType> eventTypes;

    private final String nextToken;

    private DescribeEventTypesResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypes = builder.eventTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventTypes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEventTypes() {
        return eventTypes != null && !(eventTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
     * <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example, <code>EC2</code>,
     * <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the format
     * <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
     *         <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example,
     *         <code>EC2</code>, <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the
     *         format <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
     *         <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
     */
    public List<EventType> eventTypes() {
        return eventTypes;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypes() ? eventTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTypesResponse)) {
            return false;
        }
        DescribeEventTypesResponse other = (DescribeEventTypesResponse) obj;
        return hasEventTypes() == other.hasEventTypes() && Objects.equals(eventTypes(), other.eventTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventTypesResponse").add("EventTypes", hasEventTypes() ? eventTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTypes":
            return Optional.ofNullable(clazz.cast(eventTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTypesResponse, T> g) {
        return obj -> g.apply((DescribeEventTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventTypesResponse> {
        /**
         * <p>
         * A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
         * <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example, <code>EC2</code>,
         * <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the format
         * <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
         * <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
         * </p>
         * 
         * @param eventTypes
         *        A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example,
         *        <code>EC2</code>, <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in
         *        the format <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
         *        <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(Collection<EventType> eventTypes);

        /**
         * <p>
         * A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
         * <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example, <code>EC2</code>,
         * <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the format
         * <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
         * <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
         * </p>
         * 
         * @param eventTypes
         *        A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example,
         *        <code>EC2</code>, <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in
         *        the format <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
         *        <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypes(EventType... eventTypes);

        /**
         * <p>
         * A list of event types that match the filter criteria. Event types have a category (<code>issue</code>,
         * <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example, <code>EC2</code>,
         * <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the format
         * <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example,
         * <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventType>.Builder} avoiding the need to
         * create one manually via {@link List<EventType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventType>.Builder#build()} is called immediately and its
         * result is passed to {@link #eventTypes(List<EventType>)}.
         * 
         * @param eventTypes
         *        a consumer that will call methods on {@link List<EventType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTypes(List<EventType>)
         */
        Builder eventTypes(Consumer<EventType.Builder>... eventTypes);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EventType> eventTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTypesResponse model) {
            super(model);
            eventTypes(model.eventTypes);
            nextToken(model.nextToken);
        }

        public final Collection<EventType.Builder> getEventTypes() {
            if (eventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypes != null ? eventTypes.stream().map(EventType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventTypes(Collection<EventType> eventTypes) {
            this.eventTypes = EventTypeListCopier.copy(eventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(EventType... eventTypes) {
            eventTypes(Arrays.asList(eventTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypes(Consumer<EventType.Builder>... eventTypes) {
            eventTypes(Stream.of(eventTypes).map(c -> EventType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventTypes(Collection<EventType.BuilderImpl> eventTypes) {
            this.eventTypes = EventTypeListCopier.copyFromBuilder(eventTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventTypesResponse build() {
            return new DescribeEventTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
