/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values to filter results from the <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html"
 * >DescribeEventsForOrganization</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationEventFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationEventFilter.Builder, OrganizationEventFilter> {
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCodes")
            .getter(getter(OrganizationEventFilter::eventTypeCodes))
            .setter(setter(Builder::eventTypeCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("awsAccountIds")
            .getter(getter(OrganizationEventFilter::awsAccountIds))
            .setter(setter(Builder::awsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(OrganizationEventFilter::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(OrganizationEventFilter::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DateTimeRange> START_TIME_FIELD = SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("startTime").getter(getter(OrganizationEventFilter::startTime)).setter(setter(Builder::startTime))
            .constructor(DateTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<DateTimeRange> END_TIME_FIELD = SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("endTime").getter(getter(OrganizationEventFilter::endTime)).setter(setter(Builder::endTime))
            .constructor(DateTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<DateTimeRange> LAST_UPDATED_TIME_FIELD = SdkField
            .<DateTimeRange> builder(MarshallingType.SDK_POJO).memberName("lastUpdatedTime")
            .getter(getter(OrganizationEventFilter::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .constructor(DateTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<List<String>> ENTITY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityArns")
            .getter(getter(OrganizationEventFilter::entityArns))
            .setter(setter(Builder::entityArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENTITY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityValues")
            .getter(getter(OrganizationEventFilter::entityValues))
            .setter(setter(Builder::entityValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCategories")
            .getter(getter(OrganizationEventFilter::eventTypeCategoriesAsStrings))
            .setter(setter(Builder::eventTypeCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventStatusCodes")
            .getter(getter(OrganizationEventFilter::eventStatusCodesAsStrings))
            .setter(setter(Builder::eventStatusCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_CODES_FIELD,
            AWS_ACCOUNT_IDS_FIELD, SERVICES_FIELD, REGIONS_FIELD, START_TIME_FIELD, END_TIME_FIELD, LAST_UPDATED_TIME_FIELD,
            ENTITY_ARNS_FIELD, ENTITY_VALUES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, EVENT_STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventTypeCodes;

    private final List<String> awsAccountIds;

    private final List<String> services;

    private final List<String> regions;

    private final DateTimeRange startTime;

    private final DateTimeRange endTime;

    private final DateTimeRange lastUpdatedTime;

    private final List<String> entityArns;

    private final List<String> entityValues;

    private final List<String> eventTypeCategories;

    private final List<String> eventStatusCodes;

    private OrganizationEventFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.awsAccountIds = builder.awsAccountIds;
        this.services = builder.services;
        this.regions = builder.regions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.entityArns = builder.entityArns;
        this.entityValues = builder.entityValues;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.eventStatusCodes = builder.eventStatusCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCodes() {
        return eventTypeCodes != null && !(eventTypeCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers for event types. For example,
     * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCodes} method.
     * </p>
     * 
     * @return A list of unique identifiers for event types. For example,
     *         <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
     */
    public final List<String> eventTypeCodes() {
        return eventTypeCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountIds() {
        return awsAccountIds != null && !(awsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountIds} method.
     * </p>
     * 
     * @return A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
     */
    public final List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The Amazon Web Services services associated with the event. For example, <code>EC2</code>,
     *         <code>RDS</code>.
     */
    public final List<String> services() {
        return services;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Regions.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * Returns the value of the StartTime property for this object.
     * 
     * @return The value of the StartTime property for this object.
     */
    public final DateTimeRange startTime() {
        return startTime;
    }

    /**
     * Returns the value of the EndTime property for this object.
     * 
     * @return The value of the EndTime property for this object.
     */
    public final DateTimeRange endTime() {
        return endTime;
    }

    /**
     * Returns the value of the LastUpdatedTime property for this object.
     * 
     * @return The value of the LastUpdatedTime property for this object.
     */
    public final DateTimeRange lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntityArns() {
        return entityArns != null && !(entityArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity ARNs (unique identifiers).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityArns} method.
     * </p>
     * 
     * @return A list of entity ARNs (unique identifiers).
     */
    public final List<String> entityArns() {
        return entityArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityValues() {
        return entityValues != null && !(entityValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityValues} method.
     * </p>
     * 
     * @return A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
     */
    public final List<String> entityValues() {
        return entityValues;
    }

    /**
     * <p>
     * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>, or
     * <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes. Possible values are <code>issue</code>,
     *         <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
     *         <code>investigation</code> value isn't supported at this time.
     */
    public final List<EventTypeCategory> eventTypeCategories() {
        return _eventTypeCategoryListCopier.copyStringToEnum(eventTypeCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCategories() {
        return eventTypeCategories != null && !(eventTypeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>, or
     * <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes. Possible values are <code>issue</code>,
     *         <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
     *         <code>investigation</code> value isn't supported at this time.
     */
    public final List<String> eventTypeCategoriesAsStrings() {
        return eventTypeCategories;
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventStatusCodes} method.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public final List<EventStatusCode> eventStatusCodes() {
        return _eventStatusCodeListCopier.copyStringToEnum(eventStatusCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventStatusCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventStatusCodes() {
        return eventStatusCodes != null && !(eventStatusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventStatusCodes} method.
     * </p>
     * 
     * @return A list of event status codes.
     */
    public final List<String> eventStatusCodesAsStrings() {
        return eventStatusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCodes() ? eventTypeCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountIds() ? awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityArns() ? entityArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityValues() ? entityValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventStatusCodes() ? eventStatusCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEventFilter)) {
            return false;
        }
        OrganizationEventFilter other = (OrganizationEventFilter) obj;
        return hasEventTypeCodes() == other.hasEventTypeCodes() && Objects.equals(eventTypeCodes(), other.eventTypeCodes())
                && hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(awsAccountIds(), other.awsAccountIds())
                && hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasEntityArns() == other.hasEntityArns()
                && Objects.equals(entityArns(), other.entityArns()) && hasEntityValues() == other.hasEntityValues()
                && Objects.equals(entityValues(), other.entityValues())
                && hasEventTypeCategories() == other.hasEventTypeCategories()
                && Objects.equals(eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings())
                && hasEventStatusCodes() == other.hasEventStatusCodes()
                && Objects.equals(eventStatusCodesAsStrings(), other.eventStatusCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationEventFilter").add("EventTypeCodes", hasEventTypeCodes() ? eventTypeCodes() : null)
                .add("AwsAccountIds", hasAwsAccountIds() ? awsAccountIds() : null)
                .add("Services", hasServices() ? services() : null).add("Regions", hasRegions() ? regions() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("EntityArns", hasEntityArns() ? entityArns() : null)
                .add("EntityValues", hasEntityValues() ? entityValues() : null)
                .add("EventTypeCategories", hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null)
                .add("EventStatusCodes", hasEventStatusCodes() ? eventStatusCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTypeCodes":
            return Optional.ofNullable(clazz.cast(eventTypeCodes()));
        case "awsAccountIds":
            return Optional.ofNullable(clazz.cast(awsAccountIds()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "entityArns":
            return Optional.ofNullable(clazz.cast(entityArns()));
        case "entityValues":
            return Optional.ofNullable(clazz.cast(entityValues()));
        case "eventTypeCategories":
            return Optional.ofNullable(clazz.cast(eventTypeCategoriesAsStrings()));
        case "eventStatusCodes":
            return Optional.ofNullable(clazz.cast(eventStatusCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationEventFilter, T> g) {
        return obj -> g.apply((OrganizationEventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationEventFilter> {
        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(Collection<String> eventTypeCodes);

        /**
         * <p>
         * A list of unique identifiers for event types. For example,
         * <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of unique identifiers for event types. For example,
         *        <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(String... eventTypeCodes);

        /**
         * <p>
         * A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
         * </p>
         * 
         * @param awsAccountIds
         *        A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
         * </p>
         * 
         * @param awsAccountIds
         *        A list of 12-digit Amazon Web Services account numbers that contains the affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The Amazon Web Services services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services services associated with the event. For example, <code>EC2</code>,
         *        <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * The Amazon Web Services services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services services associated with the event. For example, <code>EC2</code>,
         *        <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);

        /**
         * <p>
         * A list of Amazon Web Services Regions.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * A list of Amazon Web Services Regions.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * Sets the value of the StartTime property for this object.
         *
         * @param startTime
         *        The new value for the StartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(DateTimeRange startTime);

        /**
         * Sets the value of the StartTime property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateTimeRange.Builder} avoiding the need to
         * create one manually via {@link DateTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #startTime(DateTimeRange)}.
         * 
         * @param startTime
         *        a consumer that will call methods on {@link DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTime(DateTimeRange)
         */
        default Builder startTime(Consumer<DateTimeRange.Builder> startTime) {
            return startTime(DateTimeRange.builder().applyMutation(startTime).build());
        }

        /**
         * Sets the value of the EndTime property for this object.
         *
         * @param endTime
         *        The new value for the EndTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(DateTimeRange endTime);

        /**
         * Sets the value of the EndTime property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateTimeRange.Builder} avoiding the need to
         * create one manually via {@link DateTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #endTime(DateTimeRange)}.
         * 
         * @param endTime
         *        a consumer that will call methods on {@link DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endTime(DateTimeRange)
         */
        default Builder endTime(Consumer<DateTimeRange.Builder> endTime) {
            return endTime(DateTimeRange.builder().applyMutation(endTime).build());
        }

        /**
         * Sets the value of the LastUpdatedTime property for this object.
         *
         * @param lastUpdatedTime
         *        The new value for the LastUpdatedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(DateTimeRange lastUpdatedTime);

        /**
         * Sets the value of the LastUpdatedTime property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateTimeRange.Builder} avoiding the need to
         * create one manually via {@link DateTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #lastUpdatedTime(DateTimeRange)}.
         * 
         * @param lastUpdatedTime
         *        a consumer that will call methods on {@link DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdatedTime(DateTimeRange)
         */
        default Builder lastUpdatedTime(Consumer<DateTimeRange.Builder> lastUpdatedTime) {
            return lastUpdatedTime(DateTimeRange.builder().applyMutation(lastUpdatedTime).build());
        }

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(Collection<String> entityArns);

        /**
         * <p>
         * A list of entity ARNs (unique identifiers).
         * </p>
         * 
         * @param entityArns
         *        A list of entity ARNs (unique identifiers).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArns(String... entityArns);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(Collection<String> entityValues);

        /**
         * <p>
         * A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
         * </p>
         * 
         * @param entityValues
         *        A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityValues(String... entityValues);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(String... eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes. Possible values are <code>issue</code>, <code>accountNotification</code>
         * , or <code>scheduledChange</code>. Currently, the <code>investigation</code> value isn't supported at this
         * time.
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes. Possible values are <code>issue</code>,
         *        <code>accountNotification</code>, or <code>scheduledChange</code>. Currently, the
         *        <code>investigation</code> value isn't supported at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(EventTypeCategory... eventTypeCategories);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodesWithStrings(String... eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes);

        /**
         * <p>
         * A list of event status codes.
         * </p>
         * 
         * @param eventStatusCodes
         *        A list of event status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStatusCodes(EventStatusCode... eventStatusCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private DateTimeRange startTime;

        private DateTimeRange endTime;

        private DateTimeRange lastUpdatedTime;

        private List<String> entityArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> entityValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationEventFilter model) {
            eventTypeCodes(model.eventTypeCodes);
            awsAccountIds(model.awsAccountIds);
            services(model.services);
            regions(model.regions);
            startTime(model.startTime);
            endTime(model.endTime);
            lastUpdatedTime(model.lastUpdatedTime);
            entityArns(model.entityArns);
            entityValues(model.entityValues);
            eventTypeCategoriesWithStrings(model.eventTypeCategories);
            eventStatusCodesWithStrings(model.eventStatusCodes);
        }

        public final Collection<String> getEventTypeCodes() {
            if (eventTypeCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCodes;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
        }

        @Override
        @Transient
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = _eventTypeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCodes(String... eventTypeCodes) {
            eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final Collection<String> getAwsAccountIds() {
            if (awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = _awsAccountIdsListCopier.copy(awsAccountIds);
        }

        @Override
        @Transient
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = _awsAccountIdsListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        @Override
        @Transient
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
        }

        @Override
        @Transient
        public final Builder regions(Collection<String> regions) {
            this.regions = _regionListCopier.copy(regions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final DateTimeRange.Builder getStartTime() {
            return startTime != null ? startTime.toBuilder() : null;
        }

        public final void setStartTime(DateTimeRange.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        @Transient
        public final Builder startTime(DateTimeRange startTime) {
            this.startTime = startTime;
            return this;
        }

        public final DateTimeRange.Builder getEndTime() {
            return endTime != null ? endTime.toBuilder() : null;
        }

        public final void setEndTime(DateTimeRange.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        @Transient
        public final Builder endTime(DateTimeRange endTime) {
            this.endTime = endTime;
            return this;
        }

        public final DateTimeRange.Builder getLastUpdatedTime() {
            return lastUpdatedTime != null ? lastUpdatedTime.toBuilder() : null;
        }

        public final void setLastUpdatedTime(DateTimeRange.BuilderImpl lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime != null ? lastUpdatedTime.build() : null;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(DateTimeRange lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getEntityArns() {
            if (entityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return entityArns;
        }

        public final void setEntityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
        }

        @Override
        @Transient
        public final Builder entityArns(Collection<String> entityArns) {
            this.entityArns = _entityArnListCopier.copy(entityArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityArns(String... entityArns) {
            entityArns(Arrays.asList(entityArns));
            return this;
        }

        public final Collection<String> getEntityValues() {
            if (entityValues instanceof SdkAutoConstructList) {
                return null;
            }
            return entityValues;
        }

        public final void setEntityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
        }

        @Override
        @Transient
        public final Builder entityValues(Collection<String> entityValues) {
            this.entityValues = _entityValueListCopier.copy(entityValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entityValues(String... entityValues) {
            entityValues(Arrays.asList(entityValues));
            return this;
        }

        public final Collection<String> getEventTypeCategories() {
            if (eventTypeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCategories;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        @Override
        @Transient
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String... eventTypeCategories) {
            eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        @Transient
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = _eventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory... eventTypeCategories) {
            eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final Collection<String> getEventStatusCodes() {
            if (eventStatusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventStatusCodes;
        }

        public final void setEventStatusCodes(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
        }

        @Override
        @Transient
        public final Builder eventStatusCodesWithStrings(Collection<String> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copy(eventStatusCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventStatusCodesWithStrings(String... eventStatusCodes) {
            eventStatusCodesWithStrings(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        @Transient
        public final Builder eventStatusCodes(Collection<EventStatusCode> eventStatusCodes) {
            this.eventStatusCodes = _eventStatusCodeListCopier.copyEnumToString(eventStatusCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventStatusCodes(EventStatusCode... eventStatusCodes) {
            eventStatusCodes(Arrays.asList(eventStatusCodes));
            return this;
        }

        @Override
        public OrganizationEventFilter build() {
            return new OrganizationEventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
