/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAffectedEntitiesForOrganizationResponse extends HealthResponse
        implements
        ToCopyableBuilder<DescribeAffectedEntitiesForOrganizationResponse.Builder, DescribeAffectedEntitiesForOrganizationResponse> {
    private static final SdkField<List<AffectedEntity>> ENTITIES_FIELD = SdkField
            .<List<AffectedEntity>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(DescribeAffectedEntitiesForOrganizationResponse::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AffectedEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(AffectedEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OrganizationAffectedEntitiesErrorItem>> FAILED_SET_FIELD = SdkField
            .<List<OrganizationAffectedEntitiesErrorItem>> builder(MarshallingType.LIST)
            .memberName("failedSet")
            .getter(getter(DescribeAffectedEntitiesForOrganizationResponse::failedSet))
            .setter(setter(Builder::failedSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationAffectedEntitiesErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationAffectedEntitiesErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeAffectedEntitiesForOrganizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD,
            FAILED_SET_FIELD, NEXT_TOKEN_FIELD));

    private final List<AffectedEntity> entities;

    private final List<OrganizationAffectedEntitiesErrorItem> failedSet;

    private final String nextToken;

    private DescribeAffectedEntitiesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.failedSet = builder.failedSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
     * <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
     * <code>statusCode</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
     *         <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
     *         <code>statusCode</code>.
     */
    public final List<AffectedEntity> entities() {
        return entities;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailedSet() {
        return failedSet != null && !(failedSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON set of elements of the failed response, including the <code>awsAccountId</code>, <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedSet} method.
     * </p>
     * 
     * @return A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
     *         <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
     */
    public final List<OrganizationAffectedEntitiesErrorItem> failedSet() {
        return failedSet;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedSet() ? failedSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAffectedEntitiesForOrganizationResponse)) {
            return false;
        }
        DescribeAffectedEntitiesForOrganizationResponse other = (DescribeAffectedEntitiesForOrganizationResponse) obj;
        return hasEntities() == other.hasEntities() && Objects.equals(entities(), other.entities())
                && hasFailedSet() == other.hasFailedSet() && Objects.equals(failedSet(), other.failedSet())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAffectedEntitiesForOrganizationResponse")
                .add("Entities", hasEntities() ? entities() : null).add("FailedSet", hasFailedSet() ? failedSet() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        case "failedSet":
            return Optional.ofNullable(clazz.cast(failedSet()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAffectedEntitiesForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeAffectedEntitiesForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAffectedEntitiesForOrganizationResponse> {
        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
         * <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
         * <code>statusCode</code>.
         * </p>
         * 
         * @param entities
         *        A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
         *        <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
         *        <code>statusCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<AffectedEntity> entities);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
         * <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
         * <code>statusCode</code>.
         * </p>
         * 
         * @param entities
         *        A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
         *        <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
         *        <code>statusCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(AffectedEntity... entities);

        /**
         * <p>
         * A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>,
         * <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and
         * <code>statusCode</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AffectedEntity>.Builder} avoiding
         * the need to create one manually via {@link List<AffectedEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AffectedEntity>.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<AffectedEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on {@link List<AffectedEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(List<AffectedEntity>)
         */
        Builder entities(Consumer<AffectedEntity.Builder>... entities);

        /**
         * <p>
         * A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
         * <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
         * </p>
         * 
         * @param failedSet
         *        A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
         *        <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(Collection<OrganizationAffectedEntitiesErrorItem> failedSet);

        /**
         * <p>
         * A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
         * <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
         * </p>
         * 
         * @param failedSet
         *        A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
         *        <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(OrganizationAffectedEntitiesErrorItem... failedSet);

        /**
         * <p>
         * A JSON set of elements of the failed response, including the <code>awsAccountId</code>,
         * <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <OrganizationAffectedEntitiesErrorItem>.Builder} avoiding the need to create one manually via {@link List
         * <OrganizationAffectedEntitiesErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationAffectedEntitiesErrorItem>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failedSet(List<OrganizationAffectedEntitiesErrorItem>)}.
         * 
         * @param failedSet
         *        a consumer that will call methods on {@link List<OrganizationAffectedEntitiesErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedSet(List<OrganizationAffectedEntitiesErrorItem>)
         */
        Builder failedSet(Consumer<OrganizationAffectedEntitiesErrorItem.Builder>... failedSet);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<AffectedEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private List<OrganizationAffectedEntitiesErrorItem> failedSet = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAffectedEntitiesForOrganizationResponse model) {
            super(model);
            entities(model.entities);
            failedSet(model.failedSet);
            nextToken(model.nextToken);
        }

        public final List<AffectedEntity.Builder> getEntities() {
            List<AffectedEntity.Builder> result = EntityListCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<AffectedEntity.BuilderImpl> entities) {
            this.entities = EntityListCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<AffectedEntity> entities) {
            this.entities = EntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(AffectedEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<AffectedEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> AffectedEntity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OrganizationAffectedEntitiesErrorItem.Builder> getFailedSet() {
            List<OrganizationAffectedEntitiesErrorItem.Builder> result = DescribeAffectedEntitiesForOrganizationFailedSetCopier
                    .copyToBuilder(this.failedSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedSet(Collection<OrganizationAffectedEntitiesErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeAffectedEntitiesForOrganizationFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        public final Builder failedSet(Collection<OrganizationAffectedEntitiesErrorItem> failedSet) {
            this.failedSet = DescribeAffectedEntitiesForOrganizationFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(OrganizationAffectedEntitiesErrorItem... failedSet) {
            failedSet(Arrays.asList(failedSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(Consumer<OrganizationAffectedEntitiesErrorItem.Builder>... failedSet) {
            failedSet(Stream.of(failedSet).map(c -> OrganizationAffectedEntitiesErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAffectedEntitiesForOrganizationResponse build() {
            return new DescribeAffectedEntitiesForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
