/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventDetailsForOrganizationRequest extends HealthRequest implements
        ToCopyableBuilder<DescribeEventDetailsForOrganizationRequest.Builder, DescribeEventDetailsForOrganizationRequest> {
    private static final SdkField<List<EventAccountFilter>> ORGANIZATION_EVENT_DETAIL_FILTERS_FIELD = SdkField
            .<List<EventAccountFilter>> builder(MarshallingType.LIST)
            .memberName("organizationEventDetailFilters")
            .getter(getter(DescribeEventDetailsForOrganizationRequest::organizationEventDetailFilters))
            .setter(setter(Builder::organizationEventDetailFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationEventDetailFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventAccountFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventAccountFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(DescribeEventDetailsForOrganizationRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_EVENT_DETAIL_FILTERS_FIELD, LOCALE_FIELD));

    private final List<EventAccountFilter> organizationEventDetailFilters;

    private final String locale;

    private DescribeEventDetailsForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationEventDetailFilters = builder.organizationEventDetailFilters;
        this.locale = builder.locale;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationEventDetailFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationEventDetailFilters() {
        return organizationEventDetailFilters != null && !(organizationEventDetailFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationEventDetailFilters} method.
     * </p>
     * 
     * @return A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
     */
    public final List<EventAccountFilter> organizationEventDetailFilters() {
        return organizationEventDetailFilters;
    }

    /**
     * <p>
     * The locale (language) to return information in. English (en) is the default and the only supported value at this
     * time.
     * </p>
     * 
     * @return The locale (language) to return information in. English (en) is the default and the only supported value
     *         at this time.
     */
    public final String locale() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOrganizationEventDetailFilters() ? organizationEventDetailFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsForOrganizationRequest)) {
            return false;
        }
        DescribeEventDetailsForOrganizationRequest other = (DescribeEventDetailsForOrganizationRequest) obj;
        return hasOrganizationEventDetailFilters() == other.hasOrganizationEventDetailFilters()
                && Objects.equals(organizationEventDetailFilters(), other.organizationEventDetailFilters())
                && Objects.equals(locale(), other.locale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeEventDetailsForOrganizationRequest")
                .add("OrganizationEventDetailFilters",
                        hasOrganizationEventDetailFilters() ? organizationEventDetailFilters() : null).add("Locale", locale())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "organizationEventDetailFilters":
            return Optional.ofNullable(clazz.cast(organizationEventDetailFilters()));
        case "locale":
            return Optional.ofNullable(clazz.cast(locale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsForOrganizationRequest, T> g) {
        return obj -> g.apply((DescribeEventDetailsForOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventDetailsForOrganizationRequest> {
        /**
         * <p>
         * A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEventDetailFilters
         *        A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEventDetailFilters(Collection<EventAccountFilter> organizationEventDetailFilters);

        /**
         * <p>
         * A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * 
         * @param organizationEventDetailFilters
         *        A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEventDetailFilters(EventAccountFilter... organizationEventDetailFilters);

        /**
         * <p>
         * A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EventAccountFilter>.Builder}
         * avoiding the need to create one manually via {@link List<EventAccountFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventAccountFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationEventDetailFilters(List<EventAccountFilter>)}.
         * 
         * @param organizationEventDetailFilters
         *        a consumer that will call methods on {@link List<EventAccountFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationEventDetailFilters(List<EventAccountFilter>)
         */
        Builder organizationEventDetailFilters(Consumer<EventAccountFilter.Builder>... organizationEventDetailFilters);

        /**
         * <p>
         * The locale (language) to return information in. English (en) is the default and the only supported value at
         * this time.
         * </p>
         * 
         * @param locale
         *        The locale (language) to return information in. English (en) is the default and the only supported
         *        value at this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthRequest.BuilderImpl implements Builder {
        private List<EventAccountFilter> organizationEventDetailFilters = DefaultSdkAutoConstructList.getInstance();

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsForOrganizationRequest model) {
            super(model);
            organizationEventDetailFilters(model.organizationEventDetailFilters);
            locale(model.locale);
        }

        public final List<EventAccountFilter.Builder> getOrganizationEventDetailFilters() {
            List<EventAccountFilter.Builder> result = OrganizationEventDetailFiltersListCopier
                    .copyToBuilder(this.organizationEventDetailFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationEventDetailFilters(
                Collection<EventAccountFilter.BuilderImpl> organizationEventDetailFilters) {
            this.organizationEventDetailFilters = OrganizationEventDetailFiltersListCopier
                    .copyFromBuilder(organizationEventDetailFilters);
        }

        @Override
        public final Builder organizationEventDetailFilters(Collection<EventAccountFilter> organizationEventDetailFilters) {
            this.organizationEventDetailFilters = OrganizationEventDetailFiltersListCopier.copy(organizationEventDetailFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEventDetailFilters(EventAccountFilter... organizationEventDetailFilters) {
            organizationEventDetailFilters(Arrays.asList(organizationEventDetailFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationEventDetailFilters(
                Consumer<EventAccountFilter.Builder>... organizationEventDetailFilters) {
            organizationEventDetailFilters(Stream.of(organizationEventDetailFilters)
                    .map(c -> EventAccountFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventDetailsForOrganizationRequest build() {
            return new DescribeEventDetailsForOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
