/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The values to use to filter results from the <a
 * href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventTypes.html">DescribeEventTypes</a>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTypeFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventTypeFilter.Builder, EventTypeFilter> {
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCodes")
            .getter(getter(EventTypeFilter::eventTypeCodes))
            .setter(setter(Builder::eventTypeCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(EventTypeFilter::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventTypeCategories")
            .getter(getter(EventTypeFilter::eventTypeCategoriesAsStrings))
            .setter(setter(Builder::eventTypeCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_CODES_FIELD,
            SERVICES_FIELD, EVENT_TYPE_CATEGORIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventTypeCodes;

    private final List<String> services;

    private final List<String> eventTypeCategories;

    private EventTypeFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.eventTypeCategories = builder.eventTypeCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCodes() {
        return eventTypeCodes != null && !(eventTypeCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event type codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCodes} method.
     * </p>
     * 
     * @return A list of event type codes.
     */
    public final List<String> eventTypeCodes() {
        return eventTypeCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
     */
    public final List<String> services() {
        return services;
    }

    /**
     * <p>
     * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     * <code>accountNotification</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     *         <code>accountNotification</code>).
     */
    public final List<EventTypeCategory> eventTypeCategories() {
        return EventTypeCategoryListCopier.copyStringToEnum(eventTypeCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeCategories() {
        return eventTypeCategories != null && !(eventTypeCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     * <code>accountNotification</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeCategories} method.
     * </p>
     * 
     * @return A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
     *         <code>accountNotification</code>).
     */
    public final List<String> eventTypeCategoriesAsStrings() {
        return eventTypeCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCodes() ? eventTypeCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter) obj;
        return hasEventTypeCodes() == other.hasEventTypeCodes() && Objects.equals(eventTypeCodes(), other.eventTypeCodes())
                && hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && hasEventTypeCategories() == other.hasEventTypeCategories()
                && Objects.equals(eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTypeFilter").add("EventTypeCodes", hasEventTypeCodes() ? eventTypeCodes() : null)
                .add("Services", hasServices() ? services() : null)
                .add("EventTypeCategories", hasEventTypeCategories() ? eventTypeCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTypeCodes":
            return Optional.ofNullable(clazz.cast(eventTypeCodes()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "eventTypeCategories":
            return Optional.ofNullable(clazz.cast(eventTypeCategoriesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventTypeFilter, T> g) {
        return obj -> g.apply((EventTypeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTypeFilter> {
        /**
         * <p>
         * A list of event type codes.
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of event type codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(Collection<String> eventTypeCodes);

        /**
         * <p>
         * A list of event type codes.
         * </p>
         * 
         * @param eventTypeCodes
         *        A list of event type codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCodes(String... eventTypeCodes);

        /**
         * <p>
         * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<String> services);

        /**
         * <p>
         * The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * </p>
         * 
         * @param services
         *        The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(String... services);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategoriesWithStrings(String... eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories);

        /**
         * <p>
         * A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         * <code>accountNotification</code>).
         * </p>
         * 
         * @param eventTypeCategories
         *        A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>, or
         *        <code>accountNotification</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeCategories(EventTypeCategory... eventTypeCategories);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeFilter model) {
            eventTypeCodes(model.eventTypeCodes);
            services(model.services);
            eventTypeCategoriesWithStrings(model.eventTypeCategories);
        }

        public final Collection<String> getEventTypeCodes() {
            if (eventTypeCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCodes;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
        }

        @Override
        @Transient
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCodes(String... eventTypeCodes) {
            eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        @Override
        @Transient
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(String... services) {
            services(Arrays.asList(services));
            return this;
        }

        public final Collection<String> getEventTypeCategories() {
            if (eventTypeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeCategories;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        @Override
        @Transient
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String... eventTypeCategories) {
            eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        @Transient
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory... eventTypeCategories) {
            eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public EventTypeFilter build() {
            return new EventTypeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
