/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.health.DefaultHealthAsyncClient;
import software.amazon.awssdk.services.health.DefaultHealthBaseClientBuilder;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.HealthAsyncClientBuilder;
import software.amazon.awssdk.services.health.HealthServiceClientConfiguration;
import software.amazon.awssdk.services.health.endpoints.HealthEndpointProvider;

@SdkInternalApi
final class DefaultHealthAsyncClientBuilder
extends DefaultHealthBaseClientBuilder<HealthAsyncClientBuilder, HealthAsyncClient>
implements HealthAsyncClientBuilder {
    DefaultHealthAsyncClientBuilder() {
    }

    @Override
    public DefaultHealthAsyncClientBuilder endpointProvider(HealthEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultHealthAsyncClientBuilder.validateClientOptions(clientConfiguration);
        HealthServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultHealthAsyncClient client = new DefaultHealthAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private HealthServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return HealthServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

