/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON set of elements including the <code>awsAccountId</code>, <code>eventArn</code> and a set of
 * <code>statusCodes</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityAccountFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityAccountFilter.Builder, EntityAccountFilter> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventArn").getter(getter(EntityAccountFilter::eventArn)).setter(setter(Builder::eventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(EntityAccountFilter::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<List<String>> STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusCodes")
            .getter(getter(EntityAccountFilter::statusCodesAsStrings))
            .setter(setter(Builder::statusCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD,
            AWS_ACCOUNT_ID_FIELD, STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventArn;

    private final String awsAccountId;

    private final List<String> statusCodes;

    private EntityAccountFilter(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.awsAccountId = builder.awsAccountId;
        this.statusCodes = builder.statusCodes;
    }

    /**
     * <p>
     * The unique identifier for the event. The event ARN has the
     * <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
     * format.
     * </p>
     * <p>
     * For example, an event ARN might look like the following:
     * </p>
     * <p>
     * <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
     * </p>
     * 
     * @return The unique identifier for the event. The event ARN has the
     *         <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
     *         format.</p>
     *         <p>
     *         For example, an event ARN might look like the following:
     *         </p>
     *         <p>
     *         <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
     */
    public final String eventArn() {
        return eventArn;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account numbers that contains the affected entities.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account numbers that contains the affected entities.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * A list of entity status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusCodes} method.
     * </p>
     * 
     * @return A list of entity status codes.
     */
    public final List<EntityStatusCode> statusCodes() {
        return _entityStatusCodeListCopier.copyStringToEnum(statusCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusCodes() {
        return statusCodes != null && !(statusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of entity status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusCodes} method.
     * </p>
     * 
     * @return A list of entity status codes.
     */
    public final List<String> statusCodesAsStrings() {
        return statusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusCodes() ? statusCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityAccountFilter)) {
            return false;
        }
        EntityAccountFilter other = (EntityAccountFilter) obj;
        return Objects.equals(eventArn(), other.eventArn()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && hasStatusCodes() == other.hasStatusCodes()
                && Objects.equals(statusCodesAsStrings(), other.statusCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityAccountFilter").add("EventArn", eventArn()).add("AwsAccountId", awsAccountId())
                .add("StatusCodes", hasStatusCodes() ? statusCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventArn":
            return Optional.ofNullable(clazz.cast(eventArn()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "statusCodes":
            return Optional.ofNullable(clazz.cast(statusCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityAccountFilter, T> g) {
        return obj -> g.apply((EntityAccountFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityAccountFilter> {
        /**
         * <p>
         * The unique identifier for the event. The event ARN has the
         * <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
         * format.
         * </p>
         * <p>
         * For example, an event ARN might look like the following:
         * </p>
         * <p>
         * <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
         * </p>
         * 
         * @param eventArn
         *        The unique identifier for the event. The event ARN has the
         *        <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code>
         *        format.</p>
         *        <p>
         *        For example, an event ARN might look like the following:
         *        </p>
         *        <p>
         *        <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventArn(String eventArn);

        /**
         * <p>
         * The 12-digit Amazon Web Services account numbers that contains the affected entities.
         * </p>
         * 
         * @param awsAccountId
         *        The 12-digit Amazon Web Services account numbers that contains the affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A list of entity status codes.
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodesWithStrings(Collection<String> statusCodes);

        /**
         * <p>
         * A list of entity status codes.
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodesWithStrings(String... statusCodes);

        /**
         * <p>
         * A list of entity status codes.
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(Collection<EntityStatusCode> statusCodes);

        /**
         * <p>
         * A list of entity status codes.
         * </p>
         * 
         * @param statusCodes
         *        A list of entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(EntityStatusCode... statusCodes);
    }

    static final class BuilderImpl implements Builder {
        private String eventArn;

        private String awsAccountId;

        private List<String> statusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityAccountFilter model) {
            eventArn(model.eventArn);
            awsAccountId(model.awsAccountId);
            statusCodesWithStrings(model.statusCodes);
        }

        public final String getEventArn() {
            return eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Collection<String> getStatusCodes() {
            if (statusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return statusCodes;
        }

        public final void setStatusCodes(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
        }

        @Override
        public final Builder statusCodesWithStrings(Collection<String> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copy(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodesWithStrings(String... statusCodes) {
            statusCodesWithStrings(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        public final Builder statusCodes(Collection<EntityStatusCode> statusCodes) {
            this.statusCodes = _entityStatusCodeListCopier.copyEnumToString(statusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusCodes(EntityStatusCode... statusCodes) {
            statusCodes(Arrays.asList(statusCodes));
            return this;
        }

        @Override
        public EntityAccountFilter build() {
            return new EntityAccountFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
