/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model.EventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model.EventTypeCodeListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTypeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTypeFilter> {
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTypeCodes").getter(EventTypeFilter.getter(EventTypeFilter::eventTypeCodes)).setter(EventTypeFilter.setter(Builder::eventTypeCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(EventTypeFilter.getter(EventTypeFilter::services)).setter(EventTypeFilter.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTypeCategories").getter(EventTypeFilter.getter(EventTypeFilter::eventTypeCategoriesAsStrings)).setter(EventTypeFilter.setter(Builder::eventTypeCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_CODES_FIELD, SERVICES_FIELD, EVENT_TYPE_CATEGORIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> eventTypeCategories;

    private EventTypeFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.eventTypeCategories = builder.eventTypeCategories;
    }

    public final boolean hasEventTypeCodes() {
        return this.eventTypeCodes != null && !(this.eventTypeCodes instanceof SdkAutoConstructList);
    }

    public final List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<String> services() {
        return this.services;
    }

    public final List<EventTypeCategory> eventTypeCategories() {
        return EventTypeCategoryListCopier.copyStringToEnum(this.eventTypeCategories);
    }

    public final boolean hasEventTypeCategories() {
        return this.eventTypeCategories != null && !(this.eventTypeCategories instanceof SdkAutoConstructList);
    }

    public final List<String> eventTypeCategoriesAsStrings() {
        return this.eventTypeCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypeCodes() ? this.eventTypeCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypeCategories() ? this.eventTypeCategoriesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)obj;
        return this.hasEventTypeCodes() == other.hasEventTypeCodes() && Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && this.hasEventTypeCategories() == other.hasEventTypeCategories() && Objects.equals(this.eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventTypeFilter").add("EventTypeCodes", this.hasEventTypeCodes() ? this.eventTypeCodes() : null).add("Services", this.hasServices() ? this.services() : null).add("EventTypeCategories", this.hasEventTypeCategories() ? this.eventTypeCategoriesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeCodes": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCodes()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "eventTypeCategories": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCategoriesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventTypeFilter, T> g) {
        return obj -> g.apply((EventTypeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> services = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeFilter model) {
            this.eventTypeCodes(model.eventTypeCodes);
            this.services(model.services);
            this.eventTypeCategoriesWithStrings(model.eventTypeCategories);
        }

        public final Collection<String> getEventTypeCodes() {
            if (this.eventTypeCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTypeCodes;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final Collection<String> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final Collection<String> getEventTypeCategories() {
            if (this.eventTypeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTypeCategories;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String ... eventTypeCategories) {
            this.eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public EventTypeFilter build() {
            return new EventTypeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTypeFilter> {
        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder eventTypeCategoriesWithStrings(Collection<String> var1);

        public Builder eventTypeCategoriesWithStrings(String ... var1);

        public Builder eventTypeCategories(Collection<EventTypeCategory> var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);
    }
}

