/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventDetailsRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEventDetailsRequest> {
    private static final SdkField<List<String>> EVENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventArns").getter(DescribeEventDetailsRequest.getter(DescribeEventDetailsRequest::eventArns)).setter(DescribeEventDetailsRequest.setter(Builder::eventArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DescribeEventDetailsRequest.getter(DescribeEventDetailsRequest::locale)).setter(DescribeEventDetailsRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARNS_FIELD, LOCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventArns", EVENT_ARNS_FIELD);
            this.put("locale", LOCALE_FIELD);
        }
    });
    private final List<String> eventArns;
    private final String locale;

    private DescribeEventDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.eventArns = builder.eventArns;
        this.locale = builder.locale;
    }

    public final boolean hasEventArns() {
        return this.eventArns != null && !(this.eventArns instanceof SdkAutoConstructList);
    }

    public final List<String> eventArns() {
        return this.eventArns;
    }

    public final String locale() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventArns() ? this.eventArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsRequest)) {
            return false;
        }
        DescribeEventDetailsRequest other = (DescribeEventDetailsRequest)((Object)obj);
        return this.hasEventArns() == other.hasEventArns() && Objects.equals(this.eventArns(), other.eventArns()) && Objects.equals(this.locale(), other.locale());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventDetailsRequest").add("EventArns", this.hasEventArns() ? this.eventArns() : null).add("Locale", (Object)this.locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.ofNullable(clazz.cast(this.eventArns()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsRequest, T> g) {
        return obj -> g.apply((DescribeEventDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<String> eventArns = DefaultSdkAutoConstructList.getInstance();
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsRequest model) {
            super(model);
            this.eventArns(model.eventArns);
            this.locale(model.locale);
        }

        public final Collection<String> getEventArns() {
            if (this.eventArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventArns;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventDetailsRequest build() {
            return new DescribeEventDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventDetailsRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder locale(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

