/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of entities in an account that are impacted by a specific event aggregated by the entity status codes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountEntityAggregate implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountEntityAggregate.Builder, AccountEntityAggregate> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountEntityAggregate::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(AccountEntityAggregate::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Map<String, Integer>> STATUSES_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("statuses")
            .getter(getter(AccountEntityAggregate::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, COUNT_FIELD,
            STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Integer count;

    private final Map<String, Integer> statuses;

    private AccountEntityAggregate(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.count = builder.count;
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account numbers that contains the affected entities.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account numbers that contains the affected entities.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The number of entities that match the filter criteria for the specified events.
     * </p>
     * 
     * @return The number of entities that match the filter criteria for the specified events.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of affected entities aggregated by the entity status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The number of affected entities aggregated by the entity status codes.
     */
    public final Map<EntityStatusCode, Integer> statuses() {
        return _entityStatusesCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of affected entities aggregated by the entity status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The number of affected entities aggregated by the entity status codes.
     */
    public final Map<String, Integer> statusesAsStrings() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEntityAggregate)) {
            return false;
        }
        AccountEntityAggregate other = (AccountEntityAggregate) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(count(), other.count())
                && hasStatuses() == other.hasStatuses() && Objects.equals(statusesAsStrings(), other.statusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountEntityAggregate").add("AccountId", accountId()).add("Count", count())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("statuses", STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEntityAggregate, T> g) {
        return obj -> g.apply((AccountEntityAggregate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountEntityAggregate> {
        /**
         * <p>
         * The 12-digit Amazon Web Services account numbers that contains the affected entities.
         * </p>
         * 
         * @param accountId
         *        The 12-digit Amazon Web Services account numbers that contains the affected entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The number of entities that match the filter criteria for the specified events.
         * </p>
         * 
         * @param count
         *        The number of entities that match the filter criteria for the specified events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of affected entities aggregated by the entity status codes.
         * </p>
         * 
         * @param statuses
         *        The number of affected entities aggregated by the entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Map<String, Integer> statuses);

        /**
         * <p>
         * The number of affected entities aggregated by the entity status codes.
         * </p>
         * 
         * @param statuses
         *        The number of affected entities aggregated by the entity status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Map<EntityStatusCode, Integer> statuses);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Integer count;

        private Map<String, Integer> statuses = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEntityAggregate model) {
            accountId(model.accountId);
            count(model.count);
            statusesWithStrings(model.statuses);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Map<String, Integer> getStatuses() {
            if (statuses instanceof SdkAutoConstructMap) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        public final Builder statuses(Map<EntityStatusCode, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        public AccountEntityAggregate build() {
            return new AccountEntityAggregate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
