/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventAggregatesResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEventAggregatesResponse.Builder, DescribeEventAggregatesResponse> {
    private static final SdkField<List<EventAggregate>> EVENT_AGGREGATES_FIELD = SdkField
            .<List<EventAggregate>> builder(MarshallingType.LIST)
            .memberName("eventAggregates")
            .getter(getter(DescribeEventAggregatesResponse::eventAggregates))
            .setter(setter(Builder::eventAggregates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventAggregates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventAggregate> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventAggregate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEventAggregatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_AGGREGATES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EventAggregate> eventAggregates;

    private final String nextToken;

    private DescribeEventAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.eventAggregates = builder.eventAggregates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventAggregates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventAggregates() {
        return eventAggregates != null && !(eventAggregates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of events in each category that meet the optional filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventAggregates} method.
     * </p>
     * 
     * @return The number of events in each category that meet the optional filter criteria.
     */
    public final List<EventAggregate> eventAggregates() {
        return eventAggregates;
    }

    /**
     * <p>
     * If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code>
     * pagination token is returned in the response. To retrieve the next batch of results, reissue the search request
     * and include the returned token. When all results have been returned, the response does not contain a pagination
     * token value.
     * </p>
     * 
     * @return If the results of a search are large, only a portion of the results are returned, and a
     *         <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
     *         results, reissue the search request and include the returned token. When all results have been returned,
     *         the response does not contain a pagination token value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventAggregates() ? eventAggregates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesResponse)) {
            return false;
        }
        DescribeEventAggregatesResponse other = (DescribeEventAggregatesResponse) obj;
        return hasEventAggregates() == other.hasEventAggregates() && Objects.equals(eventAggregates(), other.eventAggregates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventAggregatesResponse")
                .add("EventAggregates", hasEventAggregates() ? eventAggregates() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventAggregates":
            return Optional.ofNullable(clazz.cast(eventAggregates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventAggregates", EVENT_AGGREGATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventAggregatesResponse, T> g) {
        return obj -> g.apply((DescribeEventAggregatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventAggregatesResponse> {
        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * 
         * @param eventAggregates
         *        The number of events in each category that meet the optional filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAggregates(Collection<EventAggregate> eventAggregates);

        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * 
         * @param eventAggregates
         *        The number of events in each category that meet the optional filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventAggregates(EventAggregate... eventAggregates);

        /**
         * <p>
         * The number of events in each category that meet the optional filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.EventAggregate.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.health.model.EventAggregate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.EventAggregate.Builder#build()} is called immediately and
         * its result is passed to {@link #eventAggregates(List<EventAggregate>)}.
         * 
         * @param eventAggregates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.EventAggregate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventAggregates(java.util.Collection<EventAggregate>)
         */
        Builder eventAggregates(Consumer<EventAggregate.Builder>... eventAggregates);

        /**
         * <p>
         * If the results of a search are large, only a portion of the results are returned, and a
         * <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results,
         * reissue the search request and include the returned token. When all results have been returned, the response
         * does not contain a pagination token value.
         * </p>
         * 
         * @param nextToken
         *        If the results of a search are large, only a portion of the results are returned, and a
         *        <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of
         *        results, reissue the search request and include the returned token. When all results have been
         *        returned, the response does not contain a pagination token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<EventAggregate> eventAggregates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesResponse model) {
            super(model);
            eventAggregates(model.eventAggregates);
            nextToken(model.nextToken);
        }

        public final List<EventAggregate.Builder> getEventAggregates() {
            List<EventAggregate.Builder> result = EventAggregateListCopier.copyToBuilder(this.eventAggregates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventAggregates(Collection<EventAggregate.BuilderImpl> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copyFromBuilder(eventAggregates);
        }

        @Override
        public final Builder eventAggregates(Collection<EventAggregate> eventAggregates) {
            this.eventAggregates = EventAggregateListCopier.copy(eventAggregates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(EventAggregate... eventAggregates) {
            eventAggregates(Arrays.asList(eventAggregates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventAggregates(Consumer<EventAggregate.Builder>... eventAggregates) {
            eventAggregates(Stream.of(eventAggregates).map(c -> EventAggregate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEventAggregatesResponse build() {
            return new DescribeEventAggregatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
