/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventDetailsForOrganizationResponse extends HealthResponse implements
        ToCopyableBuilder<DescribeEventDetailsForOrganizationResponse.Builder, DescribeEventDetailsForOrganizationResponse> {
    private static final SdkField<List<OrganizationEventDetails>> SUCCESSFUL_SET_FIELD = SdkField
            .<List<OrganizationEventDetails>> builder(MarshallingType.LIST)
            .memberName("successfulSet")
            .getter(getter(DescribeEventDetailsForOrganizationResponse::successfulSet))
            .setter(setter(Builder::successfulSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationEventDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationEventDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OrganizationEventDetailsErrorItem>> FAILED_SET_FIELD = SdkField
            .<List<OrganizationEventDetailsErrorItem>> builder(MarshallingType.LIST)
            .memberName("failedSet")
            .getter(getter(DescribeEventDetailsForOrganizationResponse::failedSet))
            .setter(setter(Builder::failedSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationEventDetailsErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationEventDetailsErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_SET_FIELD,
            FAILED_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<OrganizationEventDetails> successfulSet;

    private final List<OrganizationEventDetailsErrorItem> failedSet;

    private DescribeEventDetailsForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.successfulSet = builder.successfulSet;
        this.failedSet = builder.failedSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuccessfulSet() {
        return successfulSet != null && !(successfulSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the events that could be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulSet} method.
     * </p>
     * 
     * @return Information about the events that could be retrieved.
     */
    public final List<OrganizationEventDetails> successfulSet() {
        return successfulSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailedSet() {
        return failedSet != null && !(failedSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error messages for any events that could not be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedSet} method.
     * </p>
     * 
     * @return Error messages for any events that could not be retrieved.
     */
    public final List<OrganizationEventDetailsErrorItem> failedSet() {
        return failedSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulSet() ? successfulSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedSet() ? failedSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsForOrganizationResponse)) {
            return false;
        }
        DescribeEventDetailsForOrganizationResponse other = (DescribeEventDetailsForOrganizationResponse) obj;
        return hasSuccessfulSet() == other.hasSuccessfulSet() && Objects.equals(successfulSet(), other.successfulSet())
                && hasFailedSet() == other.hasFailedSet() && Objects.equals(failedSet(), other.failedSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventDetailsForOrganizationResponse")
                .add("SuccessfulSet", hasSuccessfulSet() ? successfulSet() : null)
                .add("FailedSet", hasFailedSet() ? failedSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successfulSet":
            return Optional.ofNullable(clazz.cast(successfulSet()));
        case "failedSet":
            return Optional.ofNullable(clazz.cast(failedSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("successfulSet", SUCCESSFUL_SET_FIELD);
        map.put("failedSet", FAILED_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventDetailsForOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeEventDetailsForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventDetailsForOrganizationResponse> {
        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * 
         * @param successfulSet
         *        Information about the events that could be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSet(Collection<OrganizationEventDetails> successfulSet);

        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * 
         * @param successfulSet
         *        Information about the events that could be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulSet(OrganizationEventDetails... successfulSet);

        /**
         * <p>
         * Information about the events that could be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #successfulSet(List<OrganizationEventDetails>)}.
         * 
         * @param successfulSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.OrganizationEventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulSet(java.util.Collection<OrganizationEventDetails>)
         */
        Builder successfulSet(Consumer<OrganizationEventDetails.Builder>... successfulSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * 
         * @param failedSet
         *        Error messages for any events that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(Collection<OrganizationEventDetailsErrorItem> failedSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * 
         * @param failedSet
         *        Error messages for any events that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSet(OrganizationEventDetailsErrorItem... failedSet);

        /**
         * <p>
         * Error messages for any events that could not be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem.Builder#build()} is
         * called immediately and its result is passed to {@link #failedSet(List<OrganizationEventDetailsErrorItem>)}.
         * 
         * @param failedSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.health.model.OrganizationEventDetailsErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedSet(java.util.Collection<OrganizationEventDetailsErrorItem>)
         */
        Builder failedSet(Consumer<OrganizationEventDetailsErrorItem.Builder>... failedSet);
    }

    static final class BuilderImpl extends HealthResponse.BuilderImpl implements Builder {
        private List<OrganizationEventDetails> successfulSet = DefaultSdkAutoConstructList.getInstance();

        private List<OrganizationEventDetailsErrorItem> failedSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsForOrganizationResponse model) {
            super(model);
            successfulSet(model.successfulSet);
            failedSet(model.failedSet);
        }

        public final List<OrganizationEventDetails.Builder> getSuccessfulSet() {
            List<OrganizationEventDetails.Builder> result = DescribeEventDetailsForOrganizationSuccessfulSetCopier
                    .copyToBuilder(this.successfulSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulSet(Collection<OrganizationEventDetails.BuilderImpl> successfulSet) {
            this.successfulSet = DescribeEventDetailsForOrganizationSuccessfulSetCopier.copyFromBuilder(successfulSet);
        }

        @Override
        public final Builder successfulSet(Collection<OrganizationEventDetails> successfulSet) {
            this.successfulSet = DescribeEventDetailsForOrganizationSuccessfulSetCopier.copy(successfulSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(OrganizationEventDetails... successfulSet) {
            successfulSet(Arrays.asList(successfulSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulSet(Consumer<OrganizationEventDetails.Builder>... successfulSet) {
            successfulSet(Stream.of(successfulSet).map(c -> OrganizationEventDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OrganizationEventDetailsErrorItem.Builder> getFailedSet() {
            List<OrganizationEventDetailsErrorItem.Builder> result = DescribeEventDetailsForOrganizationFailedSetCopier
                    .copyToBuilder(this.failedSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedSet(Collection<OrganizationEventDetailsErrorItem.BuilderImpl> failedSet) {
            this.failedSet = DescribeEventDetailsForOrganizationFailedSetCopier.copyFromBuilder(failedSet);
        }

        @Override
        public final Builder failedSet(Collection<OrganizationEventDetailsErrorItem> failedSet) {
            this.failedSet = DescribeEventDetailsForOrganizationFailedSetCopier.copy(failedSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(OrganizationEventDetailsErrorItem... failedSet) {
            failedSet(Arrays.asList(failedSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedSet(Consumer<OrganizationEventDetailsErrorItem.Builder>... failedSet) {
            failedSet(Stream.of(failedSet).map(c -> OrganizationEventDetailsErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEventDetailsForOrganizationResponse build() {
            return new DescribeEventDetailsForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
