/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.health.model.AccountEntityAggregate;
import software.amazon.awssdk.services.health.model.AccountEntityAggregatesListCopier;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._entityStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationEntityAggregate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationEntityAggregate> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventArn").getter(OrganizationEntityAggregate.getter(OrganizationEntityAggregate::eventArn)).setter(OrganizationEntityAggregate.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(OrganizationEntityAggregate.getter(OrganizationEntityAggregate::count)).setter(OrganizationEntityAggregate.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Map<String, Integer>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statuses").getter(OrganizationEntityAggregate.getter(OrganizationEntityAggregate::statusesAsStrings)).setter(OrganizationEntityAggregate.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AccountEntityAggregate>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accounts").getter(OrganizationEntityAggregate.getter(OrganizationEntityAggregate::accounts)).setter(OrganizationEntityAggregate.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountEntityAggregate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, COUNT_FIELD, STATUSES_FIELD, ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrganizationEntityAggregate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventArn;
    private final Integer count;
    private final Map<String, Integer> statuses;
    private final List<AccountEntityAggregate> accounts;

    private OrganizationEntityAggregate(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.count = builder.count;
        this.statuses = builder.statuses;
        this.accounts = builder.accounts;
    }

    public final String eventArn() {
        return this.eventArn;
    }

    public final Integer count() {
        return this.count;
    }

    public final Map<EntityStatusCode, Integer> statuses() {
        return _entityStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> statusesAsStrings() {
        return this.statuses;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<AccountEntityAggregate> accounts() {
        return this.accounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEntityAggregate)) {
            return false;
        }
        OrganizationEntityAggregate other = (OrganizationEntityAggregate)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.count(), other.count()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationEntityAggregate").add("EventArn", (Object)this.eventArn()).add("Count", (Object)this.count()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("Accounts", this.hasAccounts() ? this.accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventArn", EVENT_ARN_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("statuses", STATUSES_FIELD);
        map.put("accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationEntityAggregate, T> g) {
        return obj -> g.apply((OrganizationEntityAggregate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private Integer count;
        private Map<String, Integer> statuses = DefaultSdkAutoConstructMap.getInstance();
        private List<AccountEntityAggregate> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationEntityAggregate model) {
            this.eventArn(model.eventArn);
            this.count(model.count);
            this.statusesWithStrings(model.statuses);
            this.accounts(model.accounts);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Map<String, Integer> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        public final Builder statuses(Map<EntityStatusCode, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        public final List<AccountEntityAggregate.Builder> getAccounts() {
            List<AccountEntityAggregate.Builder> result = AccountEntityAggregatesListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AccountEntityAggregate.BuilderImpl> accounts) {
            this.accounts = AccountEntityAggregatesListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<AccountEntityAggregate> accounts) {
            this.accounts = AccountEntityAggregatesListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AccountEntityAggregate ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AccountEntityAggregate.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (AccountEntityAggregate)((AccountEntityAggregate.Builder)AccountEntityAggregate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrganizationEntityAggregate build() {
            return new OrganizationEntityAggregate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationEntityAggregate> {
        public Builder eventArn(String var1);

        public Builder count(Integer var1);

        public Builder statusesWithStrings(Map<String, Integer> var1);

        public Builder statuses(Map<EntityStatusCode, Integer> var1);

        public Builder accounts(Collection<AccountEntityAggregate> var1);

        public Builder accounts(AccountEntityAggregate ... var1);

        public Builder accounts(Consumer<AccountEntityAggregate.Builder> ... var1);
    }
}

