/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input properties for the preloaded Data Store. Only data preloaded from Synthea is supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreloadDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PreloadDataConfig.Builder, PreloadDataConfig> {
    private static final SdkField<String> PRELOAD_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreloadDataType").getter(getter(PreloadDataConfig::preloadDataTypeAsString))
            .setter(setter(Builder::preloadDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRELOAD_DATA_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String preloadDataType;

    private PreloadDataConfig(BuilderImpl builder) {
        this.preloadDataType = builder.preloadDataType;
    }

    /**
     * <p>
     * The type of preloaded data. Only Synthea preloaded data is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preloadDataType}
     * will return {@link PreloadDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preloadDataTypeAsString}.
     * </p>
     * 
     * @return The type of preloaded data. Only Synthea preloaded data is supported.
     * @see PreloadDataType
     */
    public final PreloadDataType preloadDataType() {
        return PreloadDataType.fromValue(preloadDataType);
    }

    /**
     * <p>
     * The type of preloaded data. Only Synthea preloaded data is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preloadDataType}
     * will return {@link PreloadDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preloadDataTypeAsString}.
     * </p>
     * 
     * @return The type of preloaded data. Only Synthea preloaded data is supported.
     * @see PreloadDataType
     */
    public final String preloadDataTypeAsString() {
        return preloadDataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preloadDataTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreloadDataConfig)) {
            return false;
        }
        PreloadDataConfig other = (PreloadDataConfig) obj;
        return Objects.equals(preloadDataTypeAsString(), other.preloadDataTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreloadDataConfig").add("PreloadDataType", preloadDataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreloadDataType":
            return Optional.ofNullable(clazz.cast(preloadDataTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PreloadDataConfig, T> g) {
        return obj -> g.apply((PreloadDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreloadDataConfig> {
        /**
         * <p>
         * The type of preloaded data. Only Synthea preloaded data is supported.
         * </p>
         * 
         * @param preloadDataType
         *        The type of preloaded data. Only Synthea preloaded data is supported.
         * @see PreloadDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreloadDataType
         */
        Builder preloadDataType(String preloadDataType);

        /**
         * <p>
         * The type of preloaded data. Only Synthea preloaded data is supported.
         * </p>
         * 
         * @param preloadDataType
         *        The type of preloaded data. Only Synthea preloaded data is supported.
         * @see PreloadDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreloadDataType
         */
        Builder preloadDataType(PreloadDataType preloadDataType);
    }

    static final class BuilderImpl implements Builder {
        private String preloadDataType;

        private BuilderImpl() {
        }

        private BuilderImpl(PreloadDataConfig model) {
            preloadDataType(model.preloadDataType);
        }

        public final String getPreloadDataType() {
            return preloadDataType;
        }

        @Override
        public final Builder preloadDataType(String preloadDataType) {
            this.preloadDataType = preloadDataType;
            return this;
        }

        @Override
        public final Builder preloadDataType(PreloadDataType preloadDataType) {
            this.preloadDataType(preloadDataType == null ? null : preloadDataType.toString());
            return this;
        }

        public final void setPreloadDataType(String preloadDataType) {
            this.preloadDataType = preloadDataType;
        }

        @Override
        public PreloadDataConfig build() {
            return new PreloadDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
