/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.FHIRVersion;
import software.amazon.awssdk.services.healthlake.model.HealthLakeRequest;
import software.amazon.awssdk.services.healthlake.model.PreloadDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFhirDatastoreRequest
extends HealthLakeRequest
implements ToCopyableBuilder<Builder, CreateFhirDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreName").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::datastoreName)).setter(CreateFhirDatastoreRequest.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()}).build();
    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreTypeVersion").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::datastoreTypeVersionAsString)).setter(CreateFhirDatastoreRequest.setter(Builder::datastoreTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build()}).build();
    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreloadDataConfig").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::preloadDataConfig)).setter(CreateFhirDatastoreRequest.setter(Builder::preloadDataConfig)).constructor(PreloadDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateFhirDatastoreRequest.getter(CreateFhirDatastoreRequest::clientToken)).setter(CreateFhirDatastoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, DATASTORE_TYPE_VERSION_FIELD, PRELOAD_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD));
    private final String datastoreName;
    private final String datastoreTypeVersion;
    private final PreloadDataConfig preloadDataConfig;
    private final String clientToken;

    private CreateFhirDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.clientToken = builder.clientToken;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(this.datastoreTypeVersion);
    }

    public final String datastoreTypeVersionAsString() {
        return this.datastoreTypeVersion;
    }

    public final PreloadDataConfig preloadDataConfig() {
        return this.preloadDataConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFhirDatastoreRequest)) {
            return false;
        }
        CreateFhirDatastoreRequest other = (CreateFhirDatastoreRequest)((Object)obj);
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString()) && Objects.equals(this.preloadDataConfig(), other.preloadDataConfig()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFhirDatastoreRequest").add("DatastoreName", (Object)this.datastoreName()).add("DatastoreTypeVersion", (Object)this.datastoreTypeVersionAsString()).add("PreloadDataConfig", (Object)this.preloadDataConfig()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "DatastoreTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.datastoreTypeVersionAsString()));
            }
            case "PreloadDataConfig": {
                return Optional.ofNullable(clazz.cast(this.preloadDataConfig()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFhirDatastoreRequest, T> g) {
        return obj -> g.apply((CreateFhirDatastoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeRequest.BuilderImpl
    implements Builder {
        private String datastoreName;
        private String datastoreTypeVersion;
        private PreloadDataConfig preloadDataConfig;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFhirDatastoreRequest model) {
            super(model);
            this.datastoreName(model.datastoreName);
            this.datastoreTypeVersion(model.datastoreTypeVersion);
            this.preloadDataConfig(model.preloadDataConfig);
            this.clientToken(model.clientToken);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final String getDatastoreTypeVersion() {
            return this.datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return this.preloadDataConfig != null ? this.preloadDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFhirDatastoreRequest build() {
            return new CreateFhirDatastoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthLakeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFhirDatastoreRequest> {
        public Builder datastoreName(String var1);

        public Builder datastoreTypeVersion(String var1);

        public Builder datastoreTypeVersion(FHIRVersion var1);

        public Builder preloadDataConfig(PreloadDataConfig var1);

        default public Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return this.preloadDataConfig((PreloadDataConfig)((PreloadDataConfig.Builder)PreloadDataConfig.builder().applyMutation(preloadDataConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

