/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFhirImportJobRequest extends HealthLakeRequest implements
        ToCopyableBuilder<StartFhirImportJobRequest.Builder, StartFhirImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(StartFhirImportJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(StartFhirImportJobRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> JOB_OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("JobOutputDataConfig")
            .getter(getter(StartFhirImportJobRequest::jobOutputDataConfig)).setter(setter(Builder::jobOutputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobOutputDataConfig").build())
            .build();

    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(StartFhirImportJobRequest::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartFhirImportJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartFhirImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            INPUT_DATA_CONFIG_FIELD, JOB_OUTPUT_DATA_CONFIG_FIELD, DATASTORE_ID_FIELD, DATA_ACCESS_ROLE_ARN_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String jobName;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig jobOutputDataConfig;

    private final String datastoreId;

    private final String dataAccessRoleArn;

    private final String clientToken;

    private StartFhirImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.jobOutputDataConfig = builder.jobOutputDataConfig;
        this.datastoreId = builder.datastoreId;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the FHIR Import job in the StartFHIRImport job request.
     * </p>
     * 
     * @return The name of the FHIR Import job in the StartFHIRImport job request.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The input properties of the FHIR Import job in the StartFHIRImport job request.
     * </p>
     * 
     * @return The input properties of the FHIR Import job in the StartFHIRImport job request.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * Returns the value of the JobOutputDataConfig property for this object.
     * 
     * @return The value of the JobOutputDataConfig property for this object.
     */
    public final OutputDataConfig jobOutputDataConfig() {
        return jobOutputDataConfig;
    }

    /**
     * <p>
     * The AWS-generated Data Store ID.
     * </p>
     * 
     * @return The AWS-generated Data Store ID.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Optional user provided token used for ensuring idempotency.
     * </p>
     * 
     * @return Optional user provided token used for ensuring idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobOutputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFhirImportJobRequest)) {
            return false;
        }
        StartFhirImportJobRequest other = (StartFhirImportJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(jobOutputDataConfig(), other.jobOutputDataConfig())
                && Objects.equals(datastoreId(), other.datastoreId())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFhirImportJobRequest").add("JobName", jobName()).add("InputDataConfig", inputDataConfig())
                .add("JobOutputDataConfig", jobOutputDataConfig()).add("DatastoreId", datastoreId())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "JobOutputDataConfig":
            return Optional.ofNullable(clazz.cast(jobOutputDataConfig()));
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFhirImportJobRequest, T> g) {
        return obj -> g.apply((StartFhirImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFhirImportJobRequest> {
        /**
         * <p>
         * The name of the FHIR Import job in the StartFHIRImport job request.
         * </p>
         * 
         * @param jobName
         *        The name of the FHIR Import job in the StartFHIRImport job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The input properties of the FHIR Import job in the StartFHIRImport job request.
         * </p>
         * 
         * @param inputDataConfig
         *        The input properties of the FHIR Import job in the StartFHIRImport job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * The input properties of the FHIR Import job in the StartFHIRImport job request.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * Sets the value of the JobOutputDataConfig property for this object.
         *
         * @param jobOutputDataConfig
         *        The new value for the JobOutputDataConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOutputDataConfig(OutputDataConfig jobOutputDataConfig);

        /**
         * Sets the value of the JobOutputDataConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #jobOutputDataConfig(OutputDataConfig)}.
         * 
         * @param jobOutputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobOutputDataConfig(OutputDataConfig)
         */
        default Builder jobOutputDataConfig(Consumer<OutputDataConfig.Builder> jobOutputDataConfig) {
            return jobOutputDataConfig(OutputDataConfig.builder().applyMutation(jobOutputDataConfig).build());
        }

        /**
         * <p>
         * The AWS-generated Data Store ID.
         * </p>
         * 
         * @param datastoreId
         *        The AWS-generated Data Store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Optional user provided token used for ensuring idempotency.
         * </p>
         * 
         * @param clientToken
         *        Optional user provided token used for ensuring idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private String jobName;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig jobOutputDataConfig;

        private String datastoreId;

        private String dataAccessRoleArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFhirImportJobRequest model) {
            super(model);
            jobName(model.jobName);
            inputDataConfig(model.inputDataConfig);
            jobOutputDataConfig(model.jobOutputDataConfig);
            datastoreId(model.datastoreId);
            dataAccessRoleArn(model.dataAccessRoleArn);
            clientToken(model.clientToken);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getJobOutputDataConfig() {
            return jobOutputDataConfig != null ? jobOutputDataConfig.toBuilder() : null;
        }

        public final void setJobOutputDataConfig(OutputDataConfig.BuilderImpl jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig != null ? jobOutputDataConfig.build() : null;
        }

        @Override
        public final Builder jobOutputDataConfig(OutputDataConfig jobOutputDataConfig) {
            this.jobOutputDataConfig = jobOutputDataConfig;
            return this;
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFhirImportJobRequest build() {
            return new StartFhirImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
