/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeClientBuilder;
import software.amazon.awssdk.services.healthlake.model.AccessDeniedException;
import software.amazon.awssdk.services.healthlake.model.ConflictException;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.HealthLakeException;
import software.amazon.awssdk.services.healthlake.model.InternalServerException;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.healthlake.model.ResourceNotFoundException;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.TagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.TagResourceResponse;
import software.amazon.awssdk.services.healthlake.model.ThrottlingException;
import software.amazon.awssdk.services.healthlake.model.UntagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.UntagResourceResponse;
import software.amazon.awssdk.services.healthlake.model.ValidationException;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresIterable;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsIterable;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsIterable;

@SdkPublicApi
@ThreadSafe
public interface HealthLakeClient
extends SdkClient {
    public static final String SERVICE_NAME = "healthlake";
    public static final String SERVICE_METADATA_ID = "healthlake";

    public static HealthLakeClient create() {
        return (HealthLakeClient)HealthLakeClient.builder().build();
    }

    public static HealthLakeClientBuilder builder() {
        return new DefaultHealthLakeClientBuilder();
    }

    default public CreateFhirDatastoreResponse createFHIRDatastore(CreateFhirDatastoreRequest createFhirDatastoreRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public CreateFhirDatastoreResponse createFHIRDatastore(Consumer<CreateFhirDatastoreRequest.Builder> createFhirDatastoreRequest) throws ValidationException, ThrottlingException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.createFHIRDatastore((CreateFhirDatastoreRequest)((Object)((CreateFhirDatastoreRequest.Builder)CreateFhirDatastoreRequest.builder().applyMutation(createFhirDatastoreRequest)).build()));
    }

    default public DeleteFhirDatastoreResponse deleteFHIRDatastore(DeleteFhirDatastoreRequest deleteFhirDatastoreRequest) throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public DeleteFhirDatastoreResponse deleteFHIRDatastore(Consumer<DeleteFhirDatastoreRequest.Builder> deleteFhirDatastoreRequest) throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.deleteFHIRDatastore((DeleteFhirDatastoreRequest)((Object)((DeleteFhirDatastoreRequest.Builder)DeleteFhirDatastoreRequest.builder().applyMutation(deleteFhirDatastoreRequest)).build()));
    }

    default public DescribeFhirDatastoreResponse describeFHIRDatastore(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFhirDatastoreResponse describeFHIRDatastore(Consumer<DescribeFhirDatastoreRequest.Builder> describeFhirDatastoreRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.describeFHIRDatastore((DescribeFhirDatastoreRequest)((Object)((DescribeFhirDatastoreRequest.Builder)DescribeFhirDatastoreRequest.builder().applyMutation(describeFhirDatastoreRequest)).build()));
    }

    default public DescribeFhirExportJobResponse describeFHIRExportJob(DescribeFhirExportJobRequest describeFhirExportJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFhirExportJobResponse describeFHIRExportJob(Consumer<DescribeFhirExportJobRequest.Builder> describeFhirExportJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.describeFHIRExportJob((DescribeFhirExportJobRequest)((Object)((DescribeFhirExportJobRequest.Builder)DescribeFhirExportJobRequest.builder().applyMutation(describeFhirExportJobRequest)).build()));
    }

    default public DescribeFhirImportJobResponse describeFHIRImportJob(DescribeFhirImportJobRequest describeFhirImportJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public DescribeFhirImportJobResponse describeFHIRImportJob(Consumer<DescribeFhirImportJobRequest.Builder> describeFhirImportJobRequest) throws ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.describeFHIRImportJob((DescribeFhirImportJobRequest)((Object)((DescribeFhirImportJobRequest.Builder)DescribeFhirImportJobRequest.builder().applyMutation(describeFhirImportJobRequest)).build()));
    }

    default public ListFhirDatastoresResponse listFHIRDatastores(ListFhirDatastoresRequest listFhirDatastoresRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFhirDatastoresResponse listFHIRDatastores(Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRDatastores((ListFhirDatastoresRequest)((Object)((ListFhirDatastoresRequest.Builder)ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest)).build()));
    }

    default public ListFHIRDatastoresIterable listFHIRDatastoresPaginator(ListFhirDatastoresRequest listFhirDatastoresRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFHIRDatastoresIterable listFHIRDatastoresPaginator(Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) throws ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRDatastoresPaginator((ListFhirDatastoresRequest)((Object)((ListFhirDatastoresRequest.Builder)ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest)).build()));
    }

    default public ListFhirExportJobsResponse listFHIRExportJobs(ListFhirExportJobsRequest listFhirExportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFhirExportJobsResponse listFHIRExportJobs(Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRExportJobs((ListFhirExportJobsRequest)((Object)((ListFhirExportJobsRequest.Builder)ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest)).build()));
    }

    default public ListFHIRExportJobsIterable listFHIRExportJobsPaginator(ListFhirExportJobsRequest listFhirExportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFHIRExportJobsIterable listFHIRExportJobsPaginator(Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRExportJobsPaginator((ListFhirExportJobsRequest)((Object)((ListFhirExportJobsRequest.Builder)ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest)).build()));
    }

    default public ListFhirImportJobsResponse listFHIRImportJobs(ListFhirImportJobsRequest listFhirImportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFhirImportJobsResponse listFHIRImportJobs(Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRImportJobs((ListFhirImportJobsRequest)((Object)((ListFhirImportJobsRequest.Builder)ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest)).build()));
    }

    default public ListFHIRImportJobsIterable listFHIRImportJobsPaginator(ListFhirImportJobsRequest listFhirImportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListFHIRImportJobsIterable listFHIRImportJobsPaginator(Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) throws ValidationException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listFHIRImportJobsPaginator((ListFhirImportJobsRequest)((Object)((ListFhirImportJobsRequest.Builder)ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public StartFhirExportJobResponse startFHIRExportJob(StartFhirExportJobRequest startFhirExportJobRequest) throws ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public StartFhirExportJobResponse startFHIRExportJob(Consumer<StartFhirExportJobRequest.Builder> startFhirExportJobRequest) throws ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.startFHIRExportJob((StartFhirExportJobRequest)((Object)((StartFhirExportJobRequest.Builder)StartFhirExportJobRequest.builder().applyMutation(startFhirExportJobRequest)).build()));
    }

    default public StartFhirImportJobResponse startFHIRImportJob(StartFhirImportJobRequest startFhirImportJobRequest) throws ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public StartFhirImportJobResponse startFHIRImportJob(Consumer<StartFhirImportJobRequest.Builder> startFhirImportJobRequest) throws ValidationException, ThrottlingException, AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.startFHIRImportJob((StartFhirImportJobRequest)((Object)((StartFhirImportJobRequest.Builder)StartFhirImportJobRequest.builder().applyMutation(startFhirImportJobRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, HealthLakeException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"healthlake");
    }
}

