/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The server-side encryption key configuration for a customer provided encryption key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SseConfiguration.Builder, SseConfiguration> {
    private static final SdkField<KmsEncryptionConfig> KMS_ENCRYPTION_CONFIG_FIELD = SdkField
            .<KmsEncryptionConfig> builder(MarshallingType.SDK_POJO).memberName("KmsEncryptionConfig")
            .getter(getter(SseConfiguration::kmsEncryptionConfig)).setter(setter(Builder::kmsEncryptionConfig))
            .constructor(KmsEncryptionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsEncryptionConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ENCRYPTION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final KmsEncryptionConfig kmsEncryptionConfig;

    private SseConfiguration(BuilderImpl builder) {
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    /**
     * <p>
     * The KMS encryption configuration used to provide details for data encryption.
     * </p>
     * 
     * @return The KMS encryption configuration used to provide details for data encryption.
     */
    public final KmsEncryptionConfig kmsEncryptionConfig() {
        return kmsEncryptionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SseConfiguration)) {
            return false;
        }
        SseConfiguration other = (SseConfiguration) obj;
        return Objects.equals(kmsEncryptionConfig(), other.kmsEncryptionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SseConfiguration").add("KmsEncryptionConfig", kmsEncryptionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsEncryptionConfig":
            return Optional.ofNullable(clazz.cast(kmsEncryptionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SseConfiguration, T> g) {
        return obj -> g.apply((SseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SseConfiguration> {
        /**
         * <p>
         * The KMS encryption configuration used to provide details for data encryption.
         * </p>
         * 
         * @param kmsEncryptionConfig
         *        The KMS encryption configuration used to provide details for data encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionConfig(KmsEncryptionConfig kmsEncryptionConfig);

        /**
         * <p>
         * The KMS encryption configuration used to provide details for data encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link KmsEncryptionConfig.Builder} avoiding the need
         * to create one manually via {@link KmsEncryptionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link KmsEncryptionConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kmsEncryptionConfig(KmsEncryptionConfig)}.
         * 
         * @param kmsEncryptionConfig
         *        a consumer that will call methods on {@link KmsEncryptionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsEncryptionConfig(KmsEncryptionConfig)
         */
        default Builder kmsEncryptionConfig(Consumer<KmsEncryptionConfig.Builder> kmsEncryptionConfig) {
            return kmsEncryptionConfig(KmsEncryptionConfig.builder().applyMutation(kmsEncryptionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KmsEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SseConfiguration model) {
            kmsEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final KmsEncryptionConfig.Builder getKmsEncryptionConfig() {
            return kmsEncryptionConfig != null ? kmsEncryptionConfig.toBuilder() : null;
        }

        public final void setKmsEncryptionConfig(KmsEncryptionConfig.BuilderImpl kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig != null ? kmsEncryptionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder kmsEncryptionConfig(KmsEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        @Override
        public SseConfiguration build() {
            return new SseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
