/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.healthlake.model.DatastoreProperties;
import software.amazon.awssdk.services.healthlake.model.DatastorePropertiesListCopier;
import software.amazon.awssdk.services.healthlake.model.HealthLakeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFhirDatastoresResponse
extends HealthLakeResponse
implements ToCopyableBuilder<Builder, ListFhirDatastoresResponse> {
    private static final SdkField<List<DatastoreProperties>> DATASTORE_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatastorePropertiesList").getter(ListFhirDatastoresResponse.getter(ListFhirDatastoresResponse::datastorePropertiesList)).setter(ListFhirDatastoresResponse.setter(Builder::datastorePropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastorePropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatastoreProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFhirDatastoresResponse.getter(ListFhirDatastoresResponse::nextToken)).setter(ListFhirDatastoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatastoreProperties> datastorePropertiesList;
    private final String nextToken;

    private ListFhirDatastoresResponse(BuilderImpl builder) {
        super(builder);
        this.datastorePropertiesList = builder.datastorePropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatastorePropertiesList() {
        return this.datastorePropertiesList != null && !(this.datastorePropertiesList instanceof SdkAutoConstructList);
    }

    public final List<DatastoreProperties> datastorePropertiesList() {
        return this.datastorePropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatastorePropertiesList() ? this.datastorePropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirDatastoresResponse)) {
            return false;
        }
        ListFhirDatastoresResponse other = (ListFhirDatastoresResponse)((Object)obj);
        return this.hasDatastorePropertiesList() == other.hasDatastorePropertiesList() && Objects.equals(this.datastorePropertiesList(), other.datastorePropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFhirDatastoresResponse").add("DatastorePropertiesList", this.hasDatastorePropertiesList() ? this.datastorePropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastorePropertiesList": {
                return Optional.ofNullable(clazz.cast(this.datastorePropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFhirDatastoresResponse, T> g) {
        return obj -> g.apply((ListFhirDatastoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeResponse.BuilderImpl
    implements Builder {
        private List<DatastoreProperties> datastorePropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirDatastoresResponse model) {
            super(model);
            this.datastorePropertiesList(model.datastorePropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<DatastoreProperties.Builder> getDatastorePropertiesList() {
            List<DatastoreProperties.Builder> result = DatastorePropertiesListCopier.copyToBuilder(this.datastorePropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatastorePropertiesList(Collection<DatastoreProperties.BuilderImpl> datastorePropertiesList) {
            this.datastorePropertiesList = DatastorePropertiesListCopier.copyFromBuilder(datastorePropertiesList);
        }

        @Override
        public final Builder datastorePropertiesList(Collection<DatastoreProperties> datastorePropertiesList) {
            this.datastorePropertiesList = DatastorePropertiesListCopier.copy(datastorePropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datastorePropertiesList(DatastoreProperties ... datastorePropertiesList) {
            this.datastorePropertiesList(Arrays.asList(datastorePropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datastorePropertiesList(Consumer<DatastoreProperties.Builder> ... datastorePropertiesList) {
            this.datastorePropertiesList(Stream.of(datastorePropertiesList).map(c -> (DatastoreProperties)((DatastoreProperties.Builder)DatastoreProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFhirDatastoresResponse build() {
            return new ListFhirDatastoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HealthLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFhirDatastoresResponse> {
        public Builder datastorePropertiesList(Collection<DatastoreProperties> var1);

        public Builder datastorePropertiesList(DatastoreProperties ... var1);

        public Builder datastorePropertiesList(Consumer<DatastoreProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

