/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Displays the properties of the data store, including the ID, ARN, name, and the status of the data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreProperties.Builder, DatastoreProperties> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(DatastoreProperties::datastoreId)).setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreArn").getter(getter(DatastoreProperties::datastoreArn)).setter(setter(Builder::datastoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreArn").build()).build();

    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreName").getter(getter(DatastoreProperties::datastoreName))
            .setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()).build();

    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreStatus").getter(getter(DatastoreProperties::datastoreStatusAsString))
            .setter(setter(Builder::datastoreStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DatastoreProperties::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreTypeVersion").getter(getter(DatastoreProperties::datastoreTypeVersionAsString))
            .setter(setter(Builder::datastoreTypeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build())
            .build();

    private static final SdkField<String> DATASTORE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreEndpoint").getter(getter(DatastoreProperties::datastoreEndpoint))
            .setter(setter(Builder::datastoreEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreEndpoint").build()).build();

    private static final SdkField<SseConfiguration> SSE_CONFIGURATION_FIELD = SdkField
            .<SseConfiguration> builder(MarshallingType.SDK_POJO).memberName("SseConfiguration")
            .getter(getter(DatastoreProperties::sseConfiguration)).setter(setter(Builder::sseConfiguration))
            .constructor(SseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseConfiguration").build()).build();

    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField
            .<PreloadDataConfig> builder(MarshallingType.SDK_POJO).memberName("PreloadDataConfig")
            .getter(getter(DatastoreProperties::preloadDataConfig)).setter(setter(Builder::preloadDataConfig))
            .constructor(PreloadDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()).build();

    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField
            .<IdentityProviderConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IdentityProviderConfiguration")
            .getter(getter(DatastoreProperties::identityProviderConfiguration))
            .setter(setter(Builder::identityProviderConfiguration))
            .constructor(IdentityProviderConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            DATASTORE_ARN_FIELD, DATASTORE_NAME_FIELD, DATASTORE_STATUS_FIELD, CREATED_AT_FIELD, DATASTORE_TYPE_VERSION_FIELD,
            DATASTORE_ENDPOINT_FIELD, SSE_CONFIGURATION_FIELD, PRELOAD_DATA_CONFIG_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datastoreId;

    private final String datastoreArn;

    private final String datastoreName;

    private final String datastoreStatus;

    private final Instant createdAt;

    private final String datastoreTypeVersion;

    private final String datastoreEndpoint;

    private final SseConfiguration sseConfiguration;

    private final PreloadDataConfig preloadDataConfig;

    private final IdentityProviderConfiguration identityProviderConfiguration;

    private DatastoreProperties(BuilderImpl builder) {
        this.datastoreId = builder.datastoreId;
        this.datastoreArn = builder.datastoreArn;
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.createdAt = builder.createdAt;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.datastoreEndpoint = builder.datastoreEndpoint;
        this.sseConfiguration = builder.sseConfiguration;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
    }

    /**
     * <p>
     * The AWS-generated ID number for the data store.
     * </p>
     * 
     * @return The AWS-generated ID number for the data store.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The Amazon Resource Name used in the creation of the data store.
     * </p>
     * 
     * @return The Amazon Resource Name used in the creation of the data store.
     */
    public final String datastoreArn() {
        return datastoreArn;
    }

    /**
     * <p>
     * The user-generated name for the data store.
     * </p>
     * 
     * @return The user-generated name for the data store.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(datastoreStatus);
    }

    /**
     * <p>
     * The status of the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return The status of the data store.
     * @see DatastoreStatus
     */
    public final String datastoreStatusAsString() {
        return datastoreStatus;
    }

    /**
     * <p>
     * The time that a data store was created.
     * </p>
     * 
     * @return The time that a data store was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The FHIR version. Only R4 version data is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR version. Only R4 version data is supported.
     * @see FHIRVersion
     */
    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(datastoreTypeVersion);
    }

    /**
     * <p>
     * The FHIR version. Only R4 version data is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datastoreTypeVersion} will return {@link FHIRVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #datastoreTypeVersionAsString}.
     * </p>
     * 
     * @return The FHIR version. Only R4 version data is supported.
     * @see FHIRVersion
     */
    public final String datastoreTypeVersionAsString() {
        return datastoreTypeVersion;
    }

    /**
     * <p>
     * The AWS endpoint for the data store. Each data store will have it's own endpoint with data store ID in the
     * endpoint URL.
     * </p>
     * 
     * @return The AWS endpoint for the data store. Each data store will have it's own endpoint with data store ID in
     *         the endpoint URL.
     */
    public final String datastoreEndpoint() {
        return datastoreEndpoint;
    }

    /**
     * <p>
     * The server-side encryption key configuration for a customer provided encryption key (CMK).
     * </p>
     * 
     * @return The server-side encryption key configuration for a customer provided encryption key (CMK).
     */
    public final SseConfiguration sseConfiguration() {
        return sseConfiguration;
    }

    /**
     * <p>
     * The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.
     * </p>
     * 
     * @return The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.
     */
    public final PreloadDataConfig preloadDataConfig() {
        return preloadDataConfig;
    }

    /**
     * <p>
     * The identity provider that you selected when you created the data store.
     * </p>
     * 
     * @return The identity provider that you selected when you created the data store.
     */
    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return identityProviderConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreProperties)) {
            return false;
        }
        DatastoreProperties other = (DatastoreProperties) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(datastoreArn(), other.datastoreArn())
                && Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStatusAsString(), other.datastoreStatusAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString())
                && Objects.equals(datastoreEndpoint(), other.datastoreEndpoint())
                && Objects.equals(sseConfiguration(), other.sseConfiguration())
                && Objects.equals(preloadDataConfig(), other.preloadDataConfig())
                && Objects.equals(identityProviderConfiguration(), other.identityProviderConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreProperties").add("DatastoreId", datastoreId()).add("DatastoreArn", datastoreArn())
                .add("DatastoreName", datastoreName()).add("DatastoreStatus", datastoreStatusAsString())
                .add("CreatedAt", createdAt()).add("DatastoreTypeVersion", datastoreTypeVersionAsString())
                .add("DatastoreEndpoint", datastoreEndpoint()).add("SseConfiguration", sseConfiguration())
                .add("PreloadDataConfig", preloadDataConfig())
                .add("IdentityProviderConfiguration", identityProviderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "DatastoreArn":
            return Optional.ofNullable(clazz.cast(datastoreArn()));
        case "DatastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "DatastoreStatus":
            return Optional.ofNullable(clazz.cast(datastoreStatusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DatastoreTypeVersion":
            return Optional.ofNullable(clazz.cast(datastoreTypeVersionAsString()));
        case "DatastoreEndpoint":
            return Optional.ofNullable(clazz.cast(datastoreEndpoint()));
        case "SseConfiguration":
            return Optional.ofNullable(clazz.cast(sseConfiguration()));
        case "PreloadDataConfig":
            return Optional.ofNullable(clazz.cast(preloadDataConfig()));
        case "IdentityProviderConfiguration":
            return Optional.ofNullable(clazz.cast(identityProviderConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreProperties, T> g) {
        return obj -> g.apply((DatastoreProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreProperties> {
        /**
         * <p>
         * The AWS-generated ID number for the data store.
         * </p>
         * 
         * @param datastoreId
         *        The AWS-generated ID number for the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The Amazon Resource Name used in the creation of the data store.
         * </p>
         * 
         * @param datastoreArn
         *        The Amazon Resource Name used in the creation of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreArn(String datastoreArn);

        /**
         * <p>
         * The user-generated name for the data store.
         * </p>
         * 
         * @param datastoreName
         *        The user-generated name for the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param datastoreStatus
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(String datastoreStatus);

        /**
         * <p>
         * The status of the data store.
         * </p>
         * 
         * @param datastoreStatus
         *        The status of the data store.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(DatastoreStatus datastoreStatus);

        /**
         * <p>
         * The time that a data store was created.
         * </p>
         * 
         * @param createdAt
         *        The time that a data store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The FHIR version. Only R4 version data is supported.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR version. Only R4 version data is supported.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(String datastoreTypeVersion);

        /**
         * <p>
         * The FHIR version. Only R4 version data is supported.
         * </p>
         * 
         * @param datastoreTypeVersion
         *        The FHIR version. Only R4 version data is supported.
         * @see FHIRVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FHIRVersion
         */
        Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion);

        /**
         * <p>
         * The AWS endpoint for the data store. Each data store will have it's own endpoint with data store ID in the
         * endpoint URL.
         * </p>
         * 
         * @param datastoreEndpoint
         *        The AWS endpoint for the data store. Each data store will have it's own endpoint with data store ID in
         *        the endpoint URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreEndpoint(String datastoreEndpoint);

        /**
         * <p>
         * The server-side encryption key configuration for a customer provided encryption key (CMK).
         * </p>
         * 
         * @param sseConfiguration
         *        The server-side encryption key configuration for a customer provided encryption key (CMK).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfiguration(SseConfiguration sseConfiguration);

        /**
         * <p>
         * The server-side encryption key configuration for a customer provided encryption key (CMK).
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfiguration.Builder} avoiding the
         * need to create one manually via {@link SseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sseConfiguration(SseConfiguration)}.
         * 
         * @param sseConfiguration
         *        a consumer that will call methods on {@link SseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfiguration(SseConfiguration)
         */
        default Builder sseConfiguration(Consumer<SseConfiguration.Builder> sseConfiguration) {
            return sseConfiguration(SseConfiguration.builder().applyMutation(sseConfiguration).build());
        }

        /**
         * <p>
         * The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.
         * </p>
         * 
         * @param preloadDataConfig
         *        The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preloadDataConfig(PreloadDataConfig preloadDataConfig);

        /**
         * <p>
         * The preloaded data configuration for the data store. Only data preloaded from Synthea is supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link PreloadDataConfig.Builder} avoiding the
         * need to create one manually via {@link PreloadDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreloadDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #preloadDataConfig(PreloadDataConfig)}.
         * 
         * @param preloadDataConfig
         *        a consumer that will call methods on {@link PreloadDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preloadDataConfig(PreloadDataConfig)
         */
        default Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return preloadDataConfig(PreloadDataConfig.builder().applyMutation(preloadDataConfig).build());
        }

        /**
         * <p>
         * The identity provider that you selected when you created the data store.
         * </p>
         * 
         * @param identityProviderConfiguration
         *        The identity provider that you selected when you created the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration);

        /**
         * <p>
         * The identity provider that you selected when you created the data store.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProviderConfiguration.Builder}
         * avoiding the need to create one manually via {@link IdentityProviderConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProviderConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderConfiguration(IdentityProviderConfiguration)}.
         * 
         * @param identityProviderConfiguration
         *        a consumer that will call methods on {@link IdentityProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderConfiguration(IdentityProviderConfiguration)
         */
        default Builder identityProviderConfiguration(
                Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return identityProviderConfiguration(IdentityProviderConfiguration.builder()
                    .applyMutation(identityProviderConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String datastoreId;

        private String datastoreArn;

        private String datastoreName;

        private String datastoreStatus;

        private Instant createdAt;

        private String datastoreTypeVersion;

        private String datastoreEndpoint;

        private SseConfiguration sseConfiguration;

        private PreloadDataConfig preloadDataConfig;

        private IdentityProviderConfiguration identityProviderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreProperties model) {
            datastoreId(model.datastoreId);
            datastoreArn(model.datastoreArn);
            datastoreName(model.datastoreName);
            datastoreStatus(model.datastoreStatus);
            createdAt(model.createdAt);
            datastoreTypeVersion(model.datastoreTypeVersion);
            datastoreEndpoint(model.datastoreEndpoint);
            sseConfiguration(model.sseConfiguration);
            preloadDataConfig(model.preloadDataConfig);
            identityProviderConfiguration(model.identityProviderConfiguration);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreArn() {
            return datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDatastoreTypeVersion() {
            return datastoreTypeVersion;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final String getDatastoreEndpoint() {
            return datastoreEndpoint;
        }

        public final void setDatastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
        }

        @Override
        public final Builder datastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
            return this;
        }

        public final SseConfiguration.Builder getSseConfiguration() {
            return sseConfiguration != null ? sseConfiguration.toBuilder() : null;
        }

        public final void setSseConfiguration(SseConfiguration.BuilderImpl sseConfiguration) {
            this.sseConfiguration = sseConfiguration != null ? sseConfiguration.build() : null;
        }

        @Override
        public final Builder sseConfiguration(SseConfiguration sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return preloadDataConfig != null ? preloadDataConfig.toBuilder() : null;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return identityProviderConfiguration != null ? identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build()
                    : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        @Override
        public DatastoreProperties build() {
            return new DatastoreProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
