/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFhirImportJobResponse extends HealthLakeResponse implements
        ToCopyableBuilder<DescribeFhirImportJobResponse.Builder, DescribeFhirImportJobResponse> {
    private static final SdkField<ImportJobProperties> IMPORT_JOB_PROPERTIES_FIELD = SdkField
            .<ImportJobProperties> builder(MarshallingType.SDK_POJO).memberName("ImportJobProperties")
            .getter(getter(DescribeFhirImportJobResponse::importJobProperties)).setter(setter(Builder::importJobProperties))
            .constructor(ImportJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_PROPERTIES_FIELD));

    private final ImportJobProperties importJobProperties;

    private DescribeFhirImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.importJobProperties = builder.importJobProperties;
    }

    /**
     * <p>
     * The properties of the Import job request, including the ID, ARN, name, and the status of the job.
     * </p>
     * 
     * @return The properties of the Import job request, including the ID, ARN, name, and the status of the job.
     */
    public final ImportJobProperties importJobProperties() {
        return importJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFhirImportJobResponse)) {
            return false;
        }
        DescribeFhirImportJobResponse other = (DescribeFhirImportJobResponse) obj;
        return Objects.equals(importJobProperties(), other.importJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFhirImportJobResponse").add("ImportJobProperties", importJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportJobProperties":
            return Optional.ofNullable(clazz.cast(importJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFhirImportJobResponse, T> g) {
        return obj -> g.apply((DescribeFhirImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFhirImportJobResponse> {
        /**
         * <p>
         * The properties of the Import job request, including the ID, ARN, name, and the status of the job.
         * </p>
         * 
         * @param importJobProperties
         *        The properties of the Import job request, including the ID, ARN, name, and the status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobProperties(ImportJobProperties importJobProperties);

        /**
         * <p>
         * The properties of the Import job request, including the ID, ARN, name, and the status of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportJobProperties.Builder} avoiding the
         * need to create one manually via {@link ImportJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportJobProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #importJobProperties(ImportJobProperties)}.
         * 
         * @param importJobProperties
         *        a consumer that will call methods on {@link ImportJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobProperties(ImportJobProperties)
         */
        default Builder importJobProperties(Consumer<ImportJobProperties.Builder> importJobProperties) {
            return importJobProperties(ImportJobProperties.builder().applyMutation(importJobProperties).build());
        }
    }

    static final class BuilderImpl extends HealthLakeResponse.BuilderImpl implements Builder {
        private ImportJobProperties importJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFhirImportJobResponse model) {
            super(model);
            importJobProperties(model.importJobProperties);
        }

        public final ImportJobProperties.Builder getImportJobProperties() {
            return importJobProperties != null ? importJobProperties.toBuilder() : null;
        }

        public final void setImportJobProperties(ImportJobProperties.BuilderImpl importJobProperties) {
            this.importJobProperties = importJobProperties != null ? importJobProperties.build() : null;
        }

        @Override
        public final Builder importJobProperties(ImportJobProperties importJobProperties) {
            this.importJobProperties = importJobProperties;
            return this;
        }

        @Override
        public DescribeFhirImportJobResponse build() {
            return new DescribeFhirImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
