/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The customer-managed-key(CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned
 * key will be used for encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KmsEncryptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<KmsEncryptionConfig.Builder, KmsEncryptionConfig> {
    private static final SdkField<String> CMK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CmkType").getter(getter(KmsEncryptionConfig::cmkTypeAsString)).setter(setter(Builder::cmkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(KmsEncryptionConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMK_TYPE_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cmkType;

    private final String kmsKeyId;

    private KmsEncryptionConfig(BuilderImpl builder) {
        this.cmkType = builder.cmkType;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned
     * CMKs and AWS owned CMKs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cmkType} will
     * return {@link CmkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cmkTypeAsString}.
     * </p>
     * 
     * @return The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer
     *         owned CMKs and AWS owned CMKs.
     * @see CmkType
     */
    public final CmkType cmkType() {
        return CmkType.fromValue(cmkType);
    }

    /**
     * <p>
     * The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned
     * CMKs and AWS owned CMKs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cmkType} will
     * return {@link CmkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cmkTypeAsString}.
     * </p>
     * 
     * @return The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer
     *         owned CMKs and AWS owned CMKs.
     * @see CmkType
     */
    public final String cmkTypeAsString() {
        return cmkType;
    }

    /**
     * <p>
     * The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
     * </p>
     * 
     * @return The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cmkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsEncryptionConfig)) {
            return false;
        }
        KmsEncryptionConfig other = (KmsEncryptionConfig) obj;
        return Objects.equals(cmkTypeAsString(), other.cmkTypeAsString()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KmsEncryptionConfig").add("CmkType", cmkTypeAsString()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CmkType":
            return Optional.ofNullable(clazz.cast(cmkTypeAsString()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsEncryptionConfig, T> g) {
        return obj -> g.apply((KmsEncryptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KmsEncryptionConfig> {
        /**
         * <p>
         * The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned
         * CMKs and AWS owned CMKs.
         * </p>
         * 
         * @param cmkType
         *        The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are
         *        customer owned CMKs and AWS owned CMKs.
         * @see CmkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmkType
         */
        Builder cmkType(String cmkType);

        /**
         * <p>
         * The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned
         * CMKs and AWS owned CMKs.
         * </p>
         * 
         * @param cmkType
         *        The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are
         *        customer owned CMKs and AWS owned CMKs.
         * @see CmkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmkType
         */
        Builder cmkType(CmkType cmkType);

        /**
         * <p>
         * The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String cmkType;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(KmsEncryptionConfig model) {
            cmkType(model.cmkType);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getCmkType() {
            return cmkType;
        }

        public final void setCmkType(String cmkType) {
            this.cmkType = cmkType;
        }

        @Override
        public final Builder cmkType(String cmkType) {
            this.cmkType = cmkType;
            return this;
        }

        @Override
        public final Builder cmkType(CmkType cmkType) {
            this.cmkType(cmkType == null ? null : cmkType.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public KmsEncryptionConfig build() {
            return new KmsEncryptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
