/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFhirImportJobsRequest extends HealthLakeRequest implements
        ToCopyableBuilder<ListFhirImportJobsRequest.Builder, ListFhirImportJobsRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreId").getter(getter(ListFhirImportJobsRequest::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFhirImportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFhirImportJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(ListFhirImportJobsRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(ListFhirImportJobsRequest::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMITTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedBefore").getter(getter(ListFhirImportJobsRequest::submittedBefore))
            .setter(setter(Builder::submittedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedBefore").build()).build();

    private static final SdkField<Instant> SUBMITTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedAfter").getter(getter(ListFhirImportJobsRequest::submittedAfter))
            .setter(setter(Builder::submittedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, JOB_NAME_FIELD,
                    JOB_STATUS_FIELD, SUBMITTED_BEFORE_FIELD, SUBMITTED_AFTER_FIELD));

    private final String datastoreId;

    private final String nextToken;

    private final Integer maxResults;

    private final String jobName;

    private final String jobStatus;

    private final Instant submittedBefore;

    private final Instant submittedAfter;

    private ListFhirImportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submittedBefore = builder.submittedBefore;
        this.submittedAfter = builder.submittedAfter;
    }

    /**
     * <p>
     * This parameter limits the response to the import job with the specified Data Store ID.
     * </p>
     * 
     * @return This parameter limits the response to the import job with the specified Data Store ID.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
     * </p>
     * 
     * @return A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by
     * the user.
     * </p>
     * 
     * @return This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity
     *         specified by the user.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This parameter limits the response to the import job with the specified job name.
     * </p>
     * 
     * @return This parameter limits the response to the import job with the specified job name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * This parameter limits the response to the import job with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return This parameter limits the response to the import job with the specified job status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * This parameter limits the response to the import job with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return This parameter limits the response to the import job with the specified job status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * This parameter limits the response to FHIR import jobs submitted before a user specified date.
     * </p>
     * 
     * @return This parameter limits the response to FHIR import jobs submitted before a user specified date.
     */
    public final Instant submittedBefore() {
        return submittedBefore;
    }

    /**
     * <p>
     * This parameter limits the response to FHIR import jobs submitted after a user specified date.
     * </p>
     * 
     * @return This parameter limits the response to FHIR import jobs submitted after a user specified date.
     */
    public final Instant submittedAfter() {
        return submittedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirImportJobsRequest)) {
            return false;
        }
        ListFhirImportJobsRequest other = (ListFhirImportJobsRequest) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submittedBefore(), other.submittedBefore())
                && Objects.equals(submittedAfter(), other.submittedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFhirImportJobsRequest").add("DatastoreId", datastoreId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("JobName", jobName()).add("JobStatus", jobStatusAsString())
                .add("SubmittedBefore", submittedBefore()).add("SubmittedAfter", submittedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmittedBefore":
            return Optional.ofNullable(clazz.cast(submittedBefore()));
        case "SubmittedAfter":
            return Optional.ofNullable(clazz.cast(submittedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFhirImportJobsRequest, T> g) {
        return obj -> g.apply((ListFhirImportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFhirImportJobsRequest> {
        /**
         * <p>
         * This parameter limits the response to the import job with the specified Data Store ID.
         * </p>
         * 
         * @param datastoreId
         *        This parameter limits the response to the import job with the specified Data Store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified
         * by the user.
         * </p>
         * 
         * @param maxResults
         *        This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity
         *        specified by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This parameter limits the response to the import job with the specified job name.
         * </p>
         * 
         * @param jobName
         *        This parameter limits the response to the import job with the specified job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * This parameter limits the response to the import job with the specified job status.
         * </p>
         * 
         * @param jobStatus
         *        This parameter limits the response to the import job with the specified job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * This parameter limits the response to the import job with the specified job status.
         * </p>
         * 
         * @param jobStatus
         *        This parameter limits the response to the import job with the specified job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * This parameter limits the response to FHIR import jobs submitted before a user specified date.
         * </p>
         * 
         * @param submittedBefore
         *        This parameter limits the response to FHIR import jobs submitted before a user specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBefore(Instant submittedBefore);

        /**
         * <p>
         * This parameter limits the response to FHIR import jobs submitted after a user specified date.
         * </p>
         * 
         * @param submittedAfter
         *        This parameter limits the response to FHIR import jobs submitted after a user specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAfter(Instant submittedAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private String datastoreId;

        private String nextToken;

        private Integer maxResults;

        private String jobName;

        private String jobStatus;

        private Instant submittedBefore;

        private Instant submittedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirImportJobsRequest model) {
            super(model);
            datastoreId(model.datastoreId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submittedBefore(model.submittedBefore);
            submittedAfter(model.submittedAfter);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmittedBefore() {
            return submittedBefore;
        }

        public final void setSubmittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
        }

        @Override
        public final Builder submittedBefore(Instant submittedBefore) {
            this.submittedBefore = submittedBefore;
            return this;
        }

        public final Instant getSubmittedAfter() {
            return submittedAfter;
        }

        public final void setSubmittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
        }

        @Override
        public final Builder submittedAfter(Instant submittedAfter) {
            this.submittedAfter = submittedAfter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFhirImportJobsRequest build() {
            return new ListFhirImportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
