/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeBaseClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeServiceClientConfiguration;
import software.amazon.awssdk.services.healthlake.endpoints.HealthLakeEndpointProvider;

@SdkInternalApi
final class DefaultHealthLakeAsyncClientBuilder
extends DefaultHealthLakeBaseClientBuilder<HealthLakeAsyncClientBuilder, HealthLakeAsyncClient>
implements HealthLakeAsyncClientBuilder {
    DefaultHealthLakeAsyncClientBuilder() {
    }

    @Override
    public DefaultHealthLakeAsyncClientBuilder endpointProvider(HealthLakeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthLakeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultHealthLakeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        HealthLakeServiceClientConfiguration serviceClientConfiguration = HealthLakeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultHealthLakeAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

