/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeBaseClientBuilder;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeClient;
import software.amazon.awssdk.services.healthlake.HealthLakeClient;
import software.amazon.awssdk.services.healthlake.HealthLakeClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeServiceClientConfiguration;
import software.amazon.awssdk.services.healthlake.endpoints.HealthLakeEndpointProvider;

@SdkInternalApi
final class DefaultHealthLakeClientBuilder
extends DefaultHealthLakeBaseClientBuilder<HealthLakeClientBuilder, HealthLakeClient>
implements HealthLakeClientBuilder {
    DefaultHealthLakeClientBuilder() {
    }

    @Override
    public DefaultHealthLakeClientBuilder endpointProvider(HealthLakeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthLakeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultHealthLakeClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        HealthLakeServiceClientConfiguration serviceClientConfiguration = HealthLakeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultHealthLakeClient(serviceClientConfiguration, clientConfiguration);
    }
}

