/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFhirImportJobsResponse extends HealthLakeResponse implements
        ToCopyableBuilder<ListFhirImportJobsResponse.Builder, ListFhirImportJobsResponse> {
    private static final SdkField<List<ImportJobProperties>> IMPORT_JOB_PROPERTIES_LIST_FIELD = SdkField
            .<List<ImportJobProperties>> builder(MarshallingType.LIST)
            .memberName("ImportJobPropertiesList")
            .getter(getter(ListFhirImportJobsResponse::importJobPropertiesList))
            .setter(setter(Builder::importJobPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportJobProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportJobProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFhirImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IMPORT_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ImportJobProperties> importJobPropertiesList;

    private final String nextToken;

    private ListFhirImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.importJobPropertiesList = builder.importJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportJobPropertiesList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImportJobPropertiesList() {
        return importJobPropertiesList != null && !(importJobPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the progress
     * report of the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportJobPropertiesList} method.
     * </p>
     * 
     * @return The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the
     *         progress report of the job.
     */
    public final List<ImportJobProperties> importJobPropertiesList() {
        return importJobPropertiesList;
    }

    /**
     * <p>
     * A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
     * </p>
     * 
     * @return A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportJobPropertiesList() ? importJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirImportJobsResponse)) {
            return false;
        }
        ListFhirImportJobsResponse other = (ListFhirImportJobsResponse) obj;
        return hasImportJobPropertiesList() == other.hasImportJobPropertiesList()
                && Objects.equals(importJobPropertiesList(), other.importJobPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFhirImportJobsResponse")
                .add("ImportJobPropertiesList", hasImportJobPropertiesList() ? importJobPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportJobPropertiesList":
            return Optional.ofNullable(clazz.cast(importJobPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFhirImportJobsResponse, T> g) {
        return obj -> g.apply((ListFhirImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFhirImportJobsResponse> {
        /**
         * <p>
         * The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the
         * progress report of the job.
         * </p>
         * 
         * @param importJobPropertiesList
         *        The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and
         *        the progress report of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobPropertiesList(Collection<ImportJobProperties> importJobPropertiesList);

        /**
         * <p>
         * The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the
         * progress report of the job.
         * </p>
         * 
         * @param importJobPropertiesList
         *        The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and
         *        the progress report of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobPropertiesList(ImportJobProperties... importJobPropertiesList);

        /**
         * <p>
         * The properties of a listed FHIR import jobs, including the ID, ARN, name, the status of the job, and the
         * progress report of the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.healthlake.model.ImportJobProperties.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.healthlake.model.ImportJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.healthlake.model.ImportJobProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #importJobPropertiesList(List<ImportJobProperties>)}.
         * 
         * @param importJobPropertiesList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.healthlake.model.ImportJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobPropertiesList(java.util.Collection<ImportJobProperties>)
         */
        Builder importJobPropertiesList(Consumer<ImportJobProperties.Builder>... importJobPropertiesList);

        /**
         * <p>
         * A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends HealthLakeResponse.BuilderImpl implements Builder {
        private List<ImportJobProperties> importJobPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirImportJobsResponse model) {
            super(model);
            importJobPropertiesList(model.importJobPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<ImportJobProperties.Builder> getImportJobPropertiesList() {
            List<ImportJobProperties.Builder> result = ImportJobPropertiesListCopier.copyToBuilder(this.importJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobPropertiesList(Collection<ImportJobProperties.BuilderImpl> importJobPropertiesList) {
            this.importJobPropertiesList = ImportJobPropertiesListCopier.copyFromBuilder(importJobPropertiesList);
        }

        @Override
        public final Builder importJobPropertiesList(Collection<ImportJobProperties> importJobPropertiesList) {
            this.importJobPropertiesList = ImportJobPropertiesListCopier.copy(importJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobPropertiesList(ImportJobProperties... importJobPropertiesList) {
            importJobPropertiesList(Arrays.asList(importJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobPropertiesList(Consumer<ImportJobProperties.Builder>... importJobPropertiesList) {
            importJobPropertiesList(Stream.of(importJobPropertiesList)
                    .map(c -> ImportJobProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFhirImportJobsResponse build() {
            return new ListFhirImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
