/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FHIRVersion {
    R4("R4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FHIRVersion> VALUE_MAP;
    private final String value;

    private FHIRVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FHIRVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FHIRVersion> knownValues() {
        EnumSet<FHIRVersion> knownValues = EnumSet.allOf(FHIRVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FHIRVersion.class, FHIRVersion::toString);
    }
}

