/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.DatastoreStatus;
import software.amazon.awssdk.services.healthlake.model.ErrorCause;
import software.amazon.awssdk.services.healthlake.model.FHIRVersion;
import software.amazon.awssdk.services.healthlake.model.IdentityProviderConfiguration;
import software.amazon.awssdk.services.healthlake.model.PreloadDataConfig;
import software.amazon.awssdk.services.healthlake.model.SseConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreProperties> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreId").getter(DatastoreProperties.getter(DatastoreProperties::datastoreId)).setter(DatastoreProperties.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreId").build()}).build();
    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreArn").getter(DatastoreProperties.getter(DatastoreProperties::datastoreArn)).setter(DatastoreProperties.setter(Builder::datastoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreArn").build()}).build();
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreName").getter(DatastoreProperties.getter(DatastoreProperties::datastoreName)).setter(DatastoreProperties.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()}).build();
    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreStatus").getter(DatastoreProperties.getter(DatastoreProperties::datastoreStatusAsString)).setter(DatastoreProperties.setter(Builder::datastoreStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DatastoreProperties.getter(DatastoreProperties::createdAt)).setter(DatastoreProperties.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DATASTORE_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreTypeVersion").getter(DatastoreProperties.getter(DatastoreProperties::datastoreTypeVersionAsString)).setter(DatastoreProperties.setter(Builder::datastoreTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreTypeVersion").build()}).build();
    private static final SdkField<String> DATASTORE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreEndpoint").getter(DatastoreProperties.getter(DatastoreProperties::datastoreEndpoint)).setter(DatastoreProperties.setter(Builder::datastoreEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreEndpoint").build()}).build();
    private static final SdkField<SseConfiguration> SSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SseConfiguration").getter(DatastoreProperties.getter(DatastoreProperties::sseConfiguration)).setter(DatastoreProperties.setter(Builder::sseConfiguration)).constructor(SseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseConfiguration").build()}).build();
    private static final SdkField<PreloadDataConfig> PRELOAD_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreloadDataConfig").getter(DatastoreProperties.getter(DatastoreProperties::preloadDataConfig)).setter(DatastoreProperties.setter(Builder::preloadDataConfig)).constructor(PreloadDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreloadDataConfig").build()}).build();
    private static final SdkField<IdentityProviderConfiguration> IDENTITY_PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderConfiguration").getter(DatastoreProperties.getter(DatastoreProperties::identityProviderConfiguration)).setter(DatastoreProperties.setter(Builder::identityProviderConfiguration)).constructor(IdentityProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderConfiguration").build()}).build();
    private static final SdkField<ErrorCause> ERROR_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorCause").getter(DatastoreProperties.getter(DatastoreProperties::errorCause)).setter(DatastoreProperties.setter(Builder::errorCause)).constructor(ErrorCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCause").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, DATASTORE_ARN_FIELD, DATASTORE_NAME_FIELD, DATASTORE_STATUS_FIELD, CREATED_AT_FIELD, DATASTORE_TYPE_VERSION_FIELD, DATASTORE_ENDPOINT_FIELD, SSE_CONFIGURATION_FIELD, PRELOAD_DATA_CONFIG_FIELD, IDENTITY_PROVIDER_CONFIGURATION_FIELD, ERROR_CAUSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatastoreId", DATASTORE_ID_FIELD);
            this.put("DatastoreArn", DATASTORE_ARN_FIELD);
            this.put("DatastoreName", DATASTORE_NAME_FIELD);
            this.put("DatastoreStatus", DATASTORE_STATUS_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("DatastoreTypeVersion", DATASTORE_TYPE_VERSION_FIELD);
            this.put("DatastoreEndpoint", DATASTORE_ENDPOINT_FIELD);
            this.put("SseConfiguration", SSE_CONFIGURATION_FIELD);
            this.put("PreloadDataConfig", PRELOAD_DATA_CONFIG_FIELD);
            this.put("IdentityProviderConfiguration", IDENTITY_PROVIDER_CONFIGURATION_FIELD);
            this.put("ErrorCause", ERROR_CAUSE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String datastoreId;
    private final String datastoreArn;
    private final String datastoreName;
    private final String datastoreStatus;
    private final Instant createdAt;
    private final String datastoreTypeVersion;
    private final String datastoreEndpoint;
    private final SseConfiguration sseConfiguration;
    private final PreloadDataConfig preloadDataConfig;
    private final IdentityProviderConfiguration identityProviderConfiguration;
    private final ErrorCause errorCause;

    private DatastoreProperties(BuilderImpl builder) {
        this.datastoreId = builder.datastoreId;
        this.datastoreArn = builder.datastoreArn;
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.createdAt = builder.createdAt;
        this.datastoreTypeVersion = builder.datastoreTypeVersion;
        this.datastoreEndpoint = builder.datastoreEndpoint;
        this.sseConfiguration = builder.sseConfiguration;
        this.preloadDataConfig = builder.preloadDataConfig;
        this.identityProviderConfiguration = builder.identityProviderConfiguration;
        this.errorCause = builder.errorCause;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String datastoreArn() {
        return this.datastoreArn;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(this.datastoreStatus);
    }

    public final String datastoreStatusAsString() {
        return this.datastoreStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final FHIRVersion datastoreTypeVersion() {
        return FHIRVersion.fromValue(this.datastoreTypeVersion);
    }

    public final String datastoreTypeVersionAsString() {
        return this.datastoreTypeVersion;
    }

    public final String datastoreEndpoint() {
        return this.datastoreEndpoint;
    }

    public final SseConfiguration sseConfiguration() {
        return this.sseConfiguration;
    }

    public final PreloadDataConfig preloadDataConfig() {
        return this.preloadDataConfig;
    }

    public final IdentityProviderConfiguration identityProviderConfiguration() {
        return this.identityProviderConfiguration;
    }

    public final ErrorCause errorCause() {
        return this.errorCause;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreTypeVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.preloadDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCause());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreProperties)) {
            return false;
        }
        DatastoreProperties other = (DatastoreProperties)obj;
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.datastoreArn(), other.datastoreArn()) && Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreStatusAsString(), other.datastoreStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.datastoreTypeVersionAsString(), other.datastoreTypeVersionAsString()) && Objects.equals(this.datastoreEndpoint(), other.datastoreEndpoint()) && Objects.equals(this.sseConfiguration(), other.sseConfiguration()) && Objects.equals(this.preloadDataConfig(), other.preloadDataConfig()) && Objects.equals(this.identityProviderConfiguration(), other.identityProviderConfiguration()) && Objects.equals(this.errorCause(), other.errorCause());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreProperties").add("DatastoreId", (Object)this.datastoreId()).add("DatastoreArn", (Object)this.datastoreArn()).add("DatastoreName", (Object)this.datastoreName()).add("DatastoreStatus", (Object)this.datastoreStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("DatastoreTypeVersion", (Object)this.datastoreTypeVersionAsString()).add("DatastoreEndpoint", (Object)this.datastoreEndpoint()).add("SseConfiguration", (Object)this.sseConfiguration()).add("PreloadDataConfig", (Object)this.preloadDataConfig()).add("IdentityProviderConfiguration", (Object)this.identityProviderConfiguration()).add("ErrorCause", (Object)this.errorCause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "DatastoreArn": {
                return Optional.ofNullable(clazz.cast(this.datastoreArn()));
            }
            case "DatastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "DatastoreStatus": {
                return Optional.ofNullable(clazz.cast(this.datastoreStatusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DatastoreTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.datastoreTypeVersionAsString()));
            }
            case "DatastoreEndpoint": {
                return Optional.ofNullable(clazz.cast(this.datastoreEndpoint()));
            }
            case "SseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sseConfiguration()));
            }
            case "PreloadDataConfig": {
                return Optional.ofNullable(clazz.cast(this.preloadDataConfig()));
            }
            case "IdentityProviderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityProviderConfiguration()));
            }
            case "ErrorCause": {
                return Optional.ofNullable(clazz.cast(this.errorCause()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreProperties, T> g) {
        return obj -> g.apply((DatastoreProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datastoreId;
        private String datastoreArn;
        private String datastoreName;
        private String datastoreStatus;
        private Instant createdAt;
        private String datastoreTypeVersion;
        private String datastoreEndpoint;
        private SseConfiguration sseConfiguration;
        private PreloadDataConfig preloadDataConfig;
        private IdentityProviderConfiguration identityProviderConfiguration;
        private ErrorCause errorCause;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreProperties model) {
            this.datastoreId(model.datastoreId);
            this.datastoreArn(model.datastoreArn);
            this.datastoreName(model.datastoreName);
            this.datastoreStatus(model.datastoreStatus);
            this.createdAt(model.createdAt);
            this.datastoreTypeVersion(model.datastoreTypeVersion);
            this.datastoreEndpoint(model.datastoreEndpoint);
            this.sseConfiguration(model.sseConfiguration);
            this.preloadDataConfig(model.preloadDataConfig);
            this.identityProviderConfiguration(model.identityProviderConfiguration);
            this.errorCause(model.errorCause);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreArn() {
            return this.datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return this.datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDatastoreTypeVersion() {
            return this.datastoreTypeVersion;
        }

        public final void setDatastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
        }

        @Override
        public final Builder datastoreTypeVersion(String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        @Override
        public final Builder datastoreTypeVersion(FHIRVersion datastoreTypeVersion) {
            this.datastoreTypeVersion(datastoreTypeVersion == null ? null : datastoreTypeVersion.toString());
            return this;
        }

        public final String getDatastoreEndpoint() {
            return this.datastoreEndpoint;
        }

        public final void setDatastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
        }

        @Override
        public final Builder datastoreEndpoint(String datastoreEndpoint) {
            this.datastoreEndpoint = datastoreEndpoint;
            return this;
        }

        public final SseConfiguration.Builder getSseConfiguration() {
            return this.sseConfiguration != null ? this.sseConfiguration.toBuilder() : null;
        }

        public final void setSseConfiguration(SseConfiguration.BuilderImpl sseConfiguration) {
            this.sseConfiguration = sseConfiguration != null ? sseConfiguration.build() : null;
        }

        @Override
        public final Builder sseConfiguration(SseConfiguration sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        public final PreloadDataConfig.Builder getPreloadDataConfig() {
            return this.preloadDataConfig != null ? this.preloadDataConfig.toBuilder() : null;
        }

        public final void setPreloadDataConfig(PreloadDataConfig.BuilderImpl preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig != null ? preloadDataConfig.build() : null;
        }

        @Override
        public final Builder preloadDataConfig(PreloadDataConfig preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        public final IdentityProviderConfiguration.Builder getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration != null ? this.identityProviderConfiguration.toBuilder() : null;
        }

        public final void setIdentityProviderConfiguration(IdentityProviderConfiguration.BuilderImpl identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration != null ? identityProviderConfiguration.build() : null;
        }

        @Override
        public final Builder identityProviderConfiguration(IdentityProviderConfiguration identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        public final ErrorCause.Builder getErrorCause() {
            return this.errorCause != null ? this.errorCause.toBuilder() : null;
        }

        public final void setErrorCause(ErrorCause.BuilderImpl errorCause) {
            this.errorCause = errorCause != null ? errorCause.build() : null;
        }

        @Override
        public final Builder errorCause(ErrorCause errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        public DatastoreProperties build() {
            return new DatastoreProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreProperties> {
        public Builder datastoreId(String var1);

        public Builder datastoreArn(String var1);

        public Builder datastoreName(String var1);

        public Builder datastoreStatus(String var1);

        public Builder datastoreStatus(DatastoreStatus var1);

        public Builder createdAt(Instant var1);

        public Builder datastoreTypeVersion(String var1);

        public Builder datastoreTypeVersion(FHIRVersion var1);

        public Builder datastoreEndpoint(String var1);

        public Builder sseConfiguration(SseConfiguration var1);

        default public Builder sseConfiguration(Consumer<SseConfiguration.Builder> sseConfiguration) {
            return this.sseConfiguration((SseConfiguration)((SseConfiguration.Builder)SseConfiguration.builder().applyMutation(sseConfiguration)).build());
        }

        public Builder preloadDataConfig(PreloadDataConfig var1);

        default public Builder preloadDataConfig(Consumer<PreloadDataConfig.Builder> preloadDataConfig) {
            return this.preloadDataConfig((PreloadDataConfig)((PreloadDataConfig.Builder)PreloadDataConfig.builder().applyMutation(preloadDataConfig)).build());
        }

        public Builder identityProviderConfiguration(IdentityProviderConfiguration var1);

        default public Builder identityProviderConfiguration(Consumer<IdentityProviderConfiguration.Builder> identityProviderConfiguration) {
            return this.identityProviderConfiguration((IdentityProviderConfiguration)((IdentityProviderConfiguration.Builder)IdentityProviderConfiguration.builder().applyMutation(identityProviderConfiguration)).build());
        }

        public Builder errorCause(ErrorCause var1);

        default public Builder errorCause(Consumer<ErrorCause.Builder> errorCause) {
            return this.errorCause((ErrorCause)((ErrorCause.Builder)ErrorCause.builder().applyMutation(errorCause)).build());
        }
    }
}

