/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filters applied to data store query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreFilter implements SdkPojo, Serializable, ToCopyableBuilder<DatastoreFilter.Builder, DatastoreFilter> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreName").getter(getter(DatastoreFilter::datastoreName)).setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()).build();

    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatastoreStatus").getter(getter(DatastoreFilter::datastoreStatusAsString))
            .setter(setter(Builder::datastoreStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(DatastoreFilter::createdBefore)).setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(DatastoreFilter::createdAfter)).setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            DATASTORE_STATUS_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datastoreName;

    private final String datastoreStatus;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private DatastoreFilter(BuilderImpl builder) {
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
    }

    /**
     * <p>
     * Allows the user to filter data store results by name.
     * </p>
     * 
     * @return Allows the user to filter data store results by name.
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * Allows the user to filter data store results by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return Allows the user to filter data store results by status.
     * @see DatastoreStatus
     */
    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(datastoreStatus);
    }

    /**
     * <p>
     * Allows the user to filter data store results by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datastoreStatus}
     * will return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #datastoreStatusAsString}.
     * </p>
     * 
     * @return Allows the user to filter data store results by status.
     * @see DatastoreStatus
     */
    public final String datastoreStatusAsString() {
        return datastoreStatus;
    }

    /**
     * <p>
     * A filter that allows the user to set cutoff dates for records. All data stores created before the specified date
     * will be included in the results.
     * </p>
     * 
     * @return A filter that allows the user to set cutoff dates for records. All data stores created before the
     *         specified date will be included in the results.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * A filter that allows the user to set cutoff dates for records. All data stores created after the specified date
     * will be included in the results.
     * </p>
     * 
     * @return A filter that allows the user to set cutoff dates for records. All data stores created after the
     *         specified date will be included in the results.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreFilter)) {
            return false;
        }
        DatastoreFilter other = (DatastoreFilter) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(datastoreStatusAsString(), other.datastoreStatusAsString())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastoreFilter").add("DatastoreName", datastoreName())
                .add("DatastoreStatus", datastoreStatusAsString()).add("CreatedBefore", createdBefore())
                .add("CreatedAfter", createdAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "DatastoreStatus":
            return Optional.ofNullable(clazz.cast(datastoreStatusAsString()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatastoreName", DATASTORE_NAME_FIELD);
        map.put("DatastoreStatus", DATASTORE_STATUS_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastoreFilter, T> g) {
        return obj -> g.apply((DatastoreFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreFilter> {
        /**
         * <p>
         * Allows the user to filter data store results by name.
         * </p>
         * 
         * @param datastoreName
         *        Allows the user to filter data store results by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * Allows the user to filter data store results by status.
         * </p>
         * 
         * @param datastoreStatus
         *        Allows the user to filter data store results by status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(String datastoreStatus);

        /**
         * <p>
         * Allows the user to filter data store results by status.
         * </p>
         * 
         * @param datastoreStatus
         *        Allows the user to filter data store results by status.
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder datastoreStatus(DatastoreStatus datastoreStatus);

        /**
         * <p>
         * A filter that allows the user to set cutoff dates for records. All data stores created before the specified
         * date will be included in the results.
         * </p>
         * 
         * @param createdBefore
         *        A filter that allows the user to set cutoff dates for records. All data stores created before the
         *        specified date will be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * A filter that allows the user to set cutoff dates for records. All data stores created after the specified
         * date will be included in the results.
         * </p>
         * 
         * @param createdAfter
         *        A filter that allows the user to set cutoff dates for records. All data stores created after the
         *        specified date will be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);
    }

    static final class BuilderImpl implements Builder {
        private String datastoreName;

        private String datastoreStatus;

        private Instant createdBefore;

        private Instant createdAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreFilter model) {
            datastoreName(model.datastoreName);
            datastoreStatus(model.datastoreStatus);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        @Override
        public DatastoreFilter build() {
            return new DatastoreFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
