/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFhirExportJobResponse extends HealthLakeResponse implements
        ToCopyableBuilder<DescribeFhirExportJobResponse.Builder, DescribeFhirExportJobResponse> {
    private static final SdkField<ExportJobProperties> EXPORT_JOB_PROPERTIES_FIELD = SdkField
            .<ExportJobProperties> builder(MarshallingType.SDK_POJO).memberName("ExportJobProperties")
            .getter(getter(DescribeFhirExportJobResponse::exportJobProperties)).setter(setter(Builder::exportJobProperties))
            .constructor(ExportJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExportJobProperties exportJobProperties;

    private DescribeFhirExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobProperties = builder.exportJobProperties;
    }

    /**
     * <p>
     * Displays the properties of the export job, including the ID, Arn, Name, and the status of the job.
     * </p>
     * 
     * @return Displays the properties of the export job, including the ID, Arn, Name, and the status of the job.
     */
    public final ExportJobProperties exportJobProperties() {
        return exportJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFhirExportJobResponse)) {
            return false;
        }
        DescribeFhirExportJobResponse other = (DescribeFhirExportJobResponse) obj;
        return Objects.equals(exportJobProperties(), other.exportJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFhirExportJobResponse").add("ExportJobProperties", exportJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobProperties":
            return Optional.ofNullable(clazz.cast(exportJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobProperties", EXPORT_JOB_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFhirExportJobResponse, T> g) {
        return obj -> g.apply((DescribeFhirExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFhirExportJobResponse> {
        /**
         * <p>
         * Displays the properties of the export job, including the ID, Arn, Name, and the status of the job.
         * </p>
         * 
         * @param exportJobProperties
         *        Displays the properties of the export job, including the ID, Arn, Name, and the status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobProperties(ExportJobProperties exportJobProperties);

        /**
         * <p>
         * Displays the properties of the export job, including the ID, Arn, Name, and the status of the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportJobProperties.Builder} avoiding the
         * need to create one manually via {@link ExportJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportJobProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #exportJobProperties(ExportJobProperties)}.
         * 
         * @param exportJobProperties
         *        a consumer that will call methods on {@link ExportJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobProperties(ExportJobProperties)
         */
        default Builder exportJobProperties(Consumer<ExportJobProperties.Builder> exportJobProperties) {
            return exportJobProperties(ExportJobProperties.builder().applyMutation(exportJobProperties).build());
        }
    }

    static final class BuilderImpl extends HealthLakeResponse.BuilderImpl implements Builder {
        private ExportJobProperties exportJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFhirExportJobResponse model) {
            super(model);
            exportJobProperties(model.exportJobProperties);
        }

        public final ExportJobProperties.Builder getExportJobProperties() {
            return exportJobProperties != null ? exportJobProperties.toBuilder() : null;
        }

        public final void setExportJobProperties(ExportJobProperties.BuilderImpl exportJobProperties) {
            this.exportJobProperties = exportJobProperties != null ? exportJobProperties.build() : null;
        }

        @Override
        public final Builder exportJobProperties(ExportJobProperties exportJobProperties) {
            this.exportJobProperties = exportJobProperties;
            return this;
        }

        @Override
        public DescribeFhirExportJobResponse build() {
            return new DescribeFhirExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
