/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identity provider configuration that you gave when the data store was created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderConfiguration.Builder, IdentityProviderConfiguration> {
    private static final SdkField<String> AUTHORIZATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationStrategy").getter(getter(IdentityProviderConfiguration::authorizationStrategyAsString))
            .setter(setter(Builder::authorizationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationStrategy").build())
            .build();

    private static final SdkField<Boolean> FINE_GRAINED_AUTHORIZATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FineGrainedAuthorizationEnabled")
            .getter(getter(IdentityProviderConfiguration::fineGrainedAuthorizationEnabled))
            .setter(setter(Builder::fineGrainedAuthorizationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FineGrainedAuthorizationEnabled")
                    .build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(IdentityProviderConfiguration::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> IDP_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdpLambdaArn").getter(getter(IdentityProviderConfiguration::idpLambdaArn))
            .setter(setter(Builder::idpLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpLambdaArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_STRATEGY_FIELD,
            FINE_GRAINED_AUTHORIZATION_ENABLED_FIELD, METADATA_FIELD, IDP_LAMBDA_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authorizationStrategy;

    private final Boolean fineGrainedAuthorizationEnabled;

    private final String metadata;

    private final String idpLambdaArn;

    private IdentityProviderConfiguration(BuilderImpl builder) {
        this.authorizationStrategy = builder.authorizationStrategy;
        this.fineGrainedAuthorizationEnabled = builder.fineGrainedAuthorizationEnabled;
        this.metadata = builder.metadata;
        this.idpLambdaArn = builder.idpLambdaArn;
    }

    /**
     * <p>
     * The authorization strategy that you selected when you created the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationStrategy} will return {@link AuthorizationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authorizationStrategyAsString}.
     * </p>
     * 
     * @return The authorization strategy that you selected when you created the data store.
     * @see AuthorizationStrategy
     */
    public final AuthorizationStrategy authorizationStrategy() {
        return AuthorizationStrategy.fromValue(authorizationStrategy);
    }

    /**
     * <p>
     * The authorization strategy that you selected when you created the data store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationStrategy} will return {@link AuthorizationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authorizationStrategyAsString}.
     * </p>
     * 
     * @return The authorization strategy that you selected when you created the data store.
     * @see AuthorizationStrategy
     */
    public final String authorizationStrategyAsString() {
        return authorizationStrategy;
    }

    /**
     * <p>
     * If you enabled fine-grained authorization when you created the data store.
     * </p>
     * 
     * @return If you enabled fine-grained authorization when you created the data store.
     */
    public final Boolean fineGrainedAuthorizationEnabled() {
        return fineGrainedAuthorizationEnabled;
    }

    /**
     * <p>
     * The JSON metadata elements that you want to use in your identity provider configuration. Required elements are
     * listed based on the launch specification of the SMART application. For more information on all possible elements,
     * see <a href="https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in SMART's
     * App Launch specification.
     * </p>
     * <p>
     * <code>authorization_endpoint</code>: The URL to the OAuth2 authorization endpoint.
     * </p>
     * <p>
     * <code>grant_types_supported</code>: An array of grant types that are supported at the token endpoint. You must
     * provide at least one grant type option. Valid options are <code>authorization_code</code> and
     * <code>client_credentials</code>.
     * </p>
     * <p>
     * <code>token_endpoint</code>: The URL to the OAuth2 token endpoint.
     * </p>
     * <p>
     * <code>capabilities</code>: An array of strings of the SMART capabilities that the authorization server supports.
     * </p>
     * <p>
     * <code>code_challenge_methods_supported</code>: An array of strings of supported PKCE code challenge methods. You
     * must include the <code>S256</code> method in the array of PKCE code challenge methods.
     * </p>
     * 
     * @return The JSON metadata elements that you want to use in your identity provider configuration. Required
     *         elements are listed based on the launch specification of the SMART application. For more information on
     *         all possible elements, see <a
     *         href="https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in SMART's
     *         App Launch specification.</p>
     *         <p>
     *         <code>authorization_endpoint</code>: The URL to the OAuth2 authorization endpoint.
     *         </p>
     *         <p>
     *         <code>grant_types_supported</code>: An array of grant types that are supported at the token endpoint. You
     *         must provide at least one grant type option. Valid options are <code>authorization_code</code> and
     *         <code>client_credentials</code>.
     *         </p>
     *         <p>
     *         <code>token_endpoint</code>: The URL to the OAuth2 token endpoint.
     *         </p>
     *         <p>
     *         <code>capabilities</code>: An array of strings of the SMART capabilities that the authorization server
     *         supports.
     *         </p>
     *         <p>
     *         <code>code_challenge_methods_supported</code>: An array of strings of supported PKCE code challenge
     *         methods. You must include the <code>S256</code> method in the array of PKCE code challenge methods.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function that you want to use to decode the access token created by
     * the authorization server.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function that you want to use to decode the access token
     *         created by the authorization server.
     */
    public final String idpLambdaArn() {
        return idpLambdaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fineGrainedAuthorizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(idpLambdaArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderConfiguration)) {
            return false;
        }
        IdentityProviderConfiguration other = (IdentityProviderConfiguration) obj;
        return Objects.equals(authorizationStrategyAsString(), other.authorizationStrategyAsString())
                && Objects.equals(fineGrainedAuthorizationEnabled(), other.fineGrainedAuthorizationEnabled())
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(idpLambdaArn(), other.idpLambdaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderConfiguration").add("AuthorizationStrategy", authorizationStrategyAsString())
                .add("FineGrainedAuthorizationEnabled", fineGrainedAuthorizationEnabled()).add("Metadata", metadata())
                .add("IdpLambdaArn", idpLambdaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationStrategy":
            return Optional.ofNullable(clazz.cast(authorizationStrategyAsString()));
        case "FineGrainedAuthorizationEnabled":
            return Optional.ofNullable(clazz.cast(fineGrainedAuthorizationEnabled()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "IdpLambdaArn":
            return Optional.ofNullable(clazz.cast(idpLambdaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationStrategy", AUTHORIZATION_STRATEGY_FIELD);
        map.put("FineGrainedAuthorizationEnabled", FINE_GRAINED_AUTHORIZATION_ENABLED_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("IdpLambdaArn", IDP_LAMBDA_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderConfiguration, T> g) {
        return obj -> g.apply((IdentityProviderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderConfiguration> {
        /**
         * <p>
         * The authorization strategy that you selected when you created the data store.
         * </p>
         * 
         * @param authorizationStrategy
         *        The authorization strategy that you selected when you created the data store.
         * @see AuthorizationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationStrategy
         */
        Builder authorizationStrategy(String authorizationStrategy);

        /**
         * <p>
         * The authorization strategy that you selected when you created the data store.
         * </p>
         * 
         * @param authorizationStrategy
         *        The authorization strategy that you selected when you created the data store.
         * @see AuthorizationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationStrategy
         */
        Builder authorizationStrategy(AuthorizationStrategy authorizationStrategy);

        /**
         * <p>
         * If you enabled fine-grained authorization when you created the data store.
         * </p>
         * 
         * @param fineGrainedAuthorizationEnabled
         *        If you enabled fine-grained authorization when you created the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fineGrainedAuthorizationEnabled(Boolean fineGrainedAuthorizationEnabled);

        /**
         * <p>
         * The JSON metadata elements that you want to use in your identity provider configuration. Required elements
         * are listed based on the launch specification of the SMART application. For more information on all possible
         * elements, see <a href="https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a>
         * in SMART's App Launch specification.
         * </p>
         * <p>
         * <code>authorization_endpoint</code>: The URL to the OAuth2 authorization endpoint.
         * </p>
         * <p>
         * <code>grant_types_supported</code>: An array of grant types that are supported at the token endpoint. You
         * must provide at least one grant type option. Valid options are <code>authorization_code</code> and
         * <code>client_credentials</code>.
         * </p>
         * <p>
         * <code>token_endpoint</code>: The URL to the OAuth2 token endpoint.
         * </p>
         * <p>
         * <code>capabilities</code>: An array of strings of the SMART capabilities that the authorization server
         * supports.
         * </p>
         * <p>
         * <code>code_challenge_methods_supported</code>: An array of strings of supported PKCE code challenge methods.
         * You must include the <code>S256</code> method in the array of PKCE code challenge methods.
         * </p>
         * 
         * @param metadata
         *        The JSON metadata elements that you want to use in your identity provider configuration. Required
         *        elements are listed based on the launch specification of the SMART application. For more information
         *        on all possible elements, see <a
         *        href="https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata">Metadata</a> in
         *        SMART's App Launch specification.</p>
         *        <p>
         *        <code>authorization_endpoint</code>: The URL to the OAuth2 authorization endpoint.
         *        </p>
         *        <p>
         *        <code>grant_types_supported</code>: An array of grant types that are supported at the token endpoint.
         *        You must provide at least one grant type option. Valid options are <code>authorization_code</code> and
         *        <code>client_credentials</code>.
         *        </p>
         *        <p>
         *        <code>token_endpoint</code>: The URL to the OAuth2 token endpoint.
         *        </p>
         *        <p>
         *        <code>capabilities</code>: An array of strings of the SMART capabilities that the authorization server
         *        supports.
         *        </p>
         *        <p>
         *        <code>code_challenge_methods_supported</code>: An array of strings of supported PKCE code challenge
         *        methods. You must include the <code>S256</code> method in the array of PKCE code challenge methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function that you want to use to decode the access token created
         * by the authorization server.
         * </p>
         * 
         * @param idpLambdaArn
         *        The Amazon Resource Name (ARN) of the Lambda function that you want to use to decode the access token
         *        created by the authorization server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpLambdaArn(String idpLambdaArn);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationStrategy;

        private Boolean fineGrainedAuthorizationEnabled;

        private String metadata;

        private String idpLambdaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderConfiguration model) {
            authorizationStrategy(model.authorizationStrategy);
            fineGrainedAuthorizationEnabled(model.fineGrainedAuthorizationEnabled);
            metadata(model.metadata);
            idpLambdaArn(model.idpLambdaArn);
        }

        public final String getAuthorizationStrategy() {
            return authorizationStrategy;
        }

        public final void setAuthorizationStrategy(String authorizationStrategy) {
            this.authorizationStrategy = authorizationStrategy;
        }

        @Override
        public final Builder authorizationStrategy(String authorizationStrategy) {
            this.authorizationStrategy = authorizationStrategy;
            return this;
        }

        @Override
        public final Builder authorizationStrategy(AuthorizationStrategy authorizationStrategy) {
            this.authorizationStrategy(authorizationStrategy == null ? null : authorizationStrategy.toString());
            return this;
        }

        public final Boolean getFineGrainedAuthorizationEnabled() {
            return fineGrainedAuthorizationEnabled;
        }

        public final void setFineGrainedAuthorizationEnabled(Boolean fineGrainedAuthorizationEnabled) {
            this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
        }

        @Override
        public final Builder fineGrainedAuthorizationEnabled(Boolean fineGrainedAuthorizationEnabled) {
            this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getIdpLambdaArn() {
            return idpLambdaArn;
        }

        public final void setIdpLambdaArn(String idpLambdaArn) {
            this.idpLambdaArn = idpLambdaArn;
        }

        @Override
        public final Builder idpLambdaArn(String idpLambdaArn) {
            this.idpLambdaArn = idpLambdaArn;
            return this;
        }

        @Override
        public IdentityProviderConfiguration build() {
            return new IdentityProviderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
