/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.DatastoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreFilter> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreName").getter(DatastoreFilter.getter(DatastoreFilter::datastoreName)).setter(DatastoreFilter.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreName").build()}).build();
    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatastoreStatus").getter(DatastoreFilter.getter(DatastoreFilter::datastoreStatusAsString)).setter(DatastoreFilter.setter(Builder::datastoreStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatastoreStatus").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(DatastoreFilter.getter(DatastoreFilter::createdBefore)).setter(DatastoreFilter.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(DatastoreFilter.getter(DatastoreFilter::createdAfter)).setter(DatastoreFilter.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, DATASTORE_STATUS_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatastoreFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datastoreName;
    private final String datastoreStatus;
    private final Instant createdBefore;
    private final Instant createdAfter;

    private DatastoreFilter(BuilderImpl builder) {
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(this.datastoreStatus);
    }

    public final String datastoreStatusAsString() {
        return this.datastoreStatus;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreFilter)) {
            return false;
        }
        DatastoreFilter other = (DatastoreFilter)obj;
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreStatusAsString(), other.datastoreStatusAsString()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreFilter").add("DatastoreName", (Object)this.datastoreName()).add("DatastoreStatus", (Object)this.datastoreStatusAsString()).add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "DatastoreStatus": {
                return Optional.ofNullable(clazz.cast(this.datastoreStatusAsString()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatastoreName", DATASTORE_NAME_FIELD);
        map.put("DatastoreStatus", DATASTORE_STATUS_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatastoreFilter, T> g) {
        return obj -> g.apply((DatastoreFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datastoreName;
        private String datastoreStatus;
        private Instant createdBefore;
        private Instant createdAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreFilter model) {
            this.datastoreName(model.datastoreName);
            this.datastoreStatus(model.datastoreStatus);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return this.datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public DatastoreFilter build() {
            return new DatastoreFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreFilter> {
        public Builder datastoreName(String var1);

        public Builder datastoreStatus(String var1);

        public Builder datastoreStatus(DatastoreStatus var1);

        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);
    }
}

