/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.healthlake.model.HealthLakeResponse;
import software.amazon.awssdk.services.healthlake.model.ImportJobProperties;
import software.amazon.awssdk.services.healthlake.model.ImportJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFhirImportJobsResponse
extends HealthLakeResponse
implements ToCopyableBuilder<Builder, ListFhirImportJobsResponse> {
    private static final SdkField<List<ImportJobProperties>> IMPORT_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportJobPropertiesList").getter(ListFhirImportJobsResponse.getter(ListFhirImportJobsResponse::importJobPropertiesList)).setter(ListFhirImportJobsResponse.setter(Builder::importJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFhirImportJobsResponse.getter(ListFhirImportJobsResponse::nextToken)).setter(ListFhirImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFhirImportJobsResponse.memberNameToFieldInitializer();
    private final List<ImportJobProperties> importJobPropertiesList;
    private final String nextToken;

    private ListFhirImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.importJobPropertiesList = builder.importJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImportJobPropertiesList() {
        return this.importJobPropertiesList != null && !(this.importJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<ImportJobProperties> importJobPropertiesList() {
        return this.importJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportJobPropertiesList() ? this.importJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirImportJobsResponse)) {
            return false;
        }
        ListFhirImportJobsResponse other = (ListFhirImportJobsResponse)((Object)obj);
        return this.hasImportJobPropertiesList() == other.hasImportJobPropertiesList() && Objects.equals(this.importJobPropertiesList(), other.importJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFhirImportJobsResponse").add("ImportJobPropertiesList", this.hasImportJobPropertiesList() ? this.importJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.importJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImportJobPropertiesList", IMPORT_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFhirImportJobsResponse, T> g) {
        return obj -> g.apply((ListFhirImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HealthLakeResponse.BuilderImpl
    implements Builder {
        private List<ImportJobProperties> importJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirImportJobsResponse model) {
            super(model);
            this.importJobPropertiesList(model.importJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<ImportJobProperties.Builder> getImportJobPropertiesList() {
            List<ImportJobProperties.Builder> result = ImportJobPropertiesListCopier.copyToBuilder(this.importJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobPropertiesList(Collection<ImportJobProperties.BuilderImpl> importJobPropertiesList) {
            this.importJobPropertiesList = ImportJobPropertiesListCopier.copyFromBuilder(importJobPropertiesList);
        }

        @Override
        public final Builder importJobPropertiesList(Collection<ImportJobProperties> importJobPropertiesList) {
            this.importJobPropertiesList = ImportJobPropertiesListCopier.copy(importJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobPropertiesList(ImportJobProperties ... importJobPropertiesList) {
            this.importJobPropertiesList(Arrays.asList(importJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobPropertiesList(Consumer<ImportJobProperties.Builder> ... importJobPropertiesList) {
            this.importJobPropertiesList(Stream.of(importJobPropertiesList).map(c -> (ImportJobProperties)((ImportJobProperties.Builder)ImportJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFhirImportJobsResponse build() {
            return new ListFhirImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends HealthLakeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFhirImportJobsResponse> {
        public Builder importJobPropertiesList(Collection<ImportJobProperties> var1);

        public Builder importJobPropertiesList(ImportJobProperties ... var1);

        public Builder importJobPropertiesList(Consumer<ImportJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

