/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.healthlake.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.StartFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.TagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.TagResourceResponse;
import software.amazon.awssdk.services.healthlake.model.UntagResourceRequest;
import software.amazon.awssdk.services.healthlake.model.UntagResourceResponse;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher;
import software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher;
import software.amazon.awssdk.services.healthlake.waiters.HealthLakeAsyncWaiter;

/**
 * Service client for accessing HealthLake asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * This is the <i>AWS HealthLake API Reference</i>. For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/healthlake/latest/devguide/what-is.html">What is AWS HealthLake?</a> in the <i>AWS
 * HealthLake Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface HealthLakeAsyncClient extends AwsClient {
    String SERVICE_NAME = "healthlake";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "healthlake";

    /**
     * <p>
     * Create a FHIR-enabled data store.
     * </p>
     *
     * @param createFhirDatastoreRequest
     * @return A Java Future containing the result of the CreateFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.CreateFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(
            CreateFhirDatastoreRequest createFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a FHIR-enabled data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param createFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.CreateFhirDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.CreateFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/CreateFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFhirDatastoreResponse> createFHIRDatastore(
            Consumer<CreateFhirDatastoreRequest.Builder> createFhirDatastoreRequest) {
        return createFHIRDatastore(CreateFhirDatastoreRequest.builder().applyMutation(createFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Delete a FHIR-enabled data store.
     * </p>
     *
     * @param deleteFhirDatastoreRequest
     * @return A Java Future containing the result of the DeleteFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ConflictException The data store is in a transition state and the user requested action cannot be
     *         performed.</li>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DeleteFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(
            DeleteFhirDatastoreRequest deleteFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a FHIR-enabled data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param deleteFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.DeleteFhirDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ConflictException The data store is in a transition state and the user requested action cannot be
     *         performed.</li>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DeleteFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DeleteFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFhirDatastoreResponse> deleteFHIRDatastore(
            Consumer<DeleteFhirDatastoreRequest.Builder> deleteFhirDatastoreRequest) {
        return deleteFHIRDatastore(DeleteFhirDatastoreRequest.builder().applyMutation(deleteFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Get properties for a FHIR-enabled data store.
     * </p>
     *
     * @param describeFhirDatastoreRequest
     * @return A Java Future containing the result of the DescribeFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(
            DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get properties for a FHIR-enabled data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirDatastoreRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirDatastoreRequest#builder()}
     * </p>
     *
     * @param describeFhirDatastoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRDatastore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRDatastore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRDatastore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirDatastoreResponse> describeFHIRDatastore(
            Consumer<DescribeFhirDatastoreRequest.Builder> describeFhirDatastoreRequest) {
        return describeFHIRDatastore(DescribeFhirDatastoreRequest.builder().applyMutation(describeFhirDatastoreRequest).build());
    }

    /**
     * <p>
     * Get FHIR export job properties.
     * </p>
     *
     * @param describeFhirExportJobRequest
     * @return A Java Future containing the result of the DescribeFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(
            DescribeFhirExportJobRequest describeFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get FHIR export job properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirExportJobRequest#builder()}
     * </p>
     *
     * @param describeFhirExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirExportJobResponse> describeFHIRExportJob(
            Consumer<DescribeFhirExportJobRequest.Builder> describeFhirExportJobRequest) {
        return describeFHIRExportJob(DescribeFhirExportJobRequest.builder().applyMutation(describeFhirExportJobRequest).build());
    }

    /**
     * <p>
     * Get the import job properties to learn more about the job or job progress.
     * </p>
     *
     * @param describeFhirImportJobRequest
     * @return A Java Future containing the result of the DescribeFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(
            DescribeFhirImportJobRequest describeFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the import job properties to learn more about the job or job progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFhirImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFhirImportJobRequest#builder()}
     * </p>
     *
     * @param describeFhirImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.DescribeFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/DescribeFHIRImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFhirImportJobResponse> describeFHIRImportJob(
            Consumer<DescribeFhirImportJobRequest.Builder> describeFhirImportJobRequest) {
        return describeFHIRImportJob(DescribeFhirImportJobRequest.builder().applyMutation(describeFhirImportJobRequest).build());
    }

    /**
     * <p>
     * List all FHIR-enabled data stores in a user’s account, regardless of data store status.
     * </p>
     *
     * @param listFhirDatastoresRequest
     * @return A Java Future containing the result of the ListFHIRDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all FHIR-enabled data stores in a user’s account, regardless of data store status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirDatastoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirDatastoresRequest#builder()}
     * </p>
     *
     * @param listFhirDatastoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFHIRDatastores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirDatastoresResponse> listFHIRDatastores(
            Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return listFHIRDatastores(ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFhirDatastoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(ListFhirDatastoresRequest listFhirDatastoresRequest) {
        return new ListFHIRDatastoresPublisher(this, listFhirDatastoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRDatastoresPublisher publisher = client.listFHIRDatastoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRDatastores(software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirDatastoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirDatastoresRequest#builder()}
     * </p>
     *
     * @param listFhirDatastoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirDatastoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRDatastores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRDatastores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRDatastoresPublisher listFHIRDatastoresPaginator(
            Consumer<ListFhirDatastoresRequest.Builder> listFhirDatastoresRequest) {
        return listFHIRDatastoresPaginator(ListFhirDatastoresRequest.builder().applyMutation(listFhirDatastoresRequest).build());
    }

    /**
     * <p>
     * Lists all FHIR export jobs associated with an account and their statuses.
     * </p>
     *
     * @param listFhirExportJobsRequest
     * @return A Java Future containing the result of the ListFHIRExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirExportJobsResponse> listFHIRExportJobs(ListFhirExportJobsRequest listFhirExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all FHIR export jobs associated with an account and their statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirExportJobsRequest#builder()}
     * </p>
     *
     * @param listFhirExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFHIRExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirExportJobsResponse> listFHIRExportJobs(
            Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) {
        return listFHIRExportJobs(ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRExportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher publisher = client.listFHIRExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher publisher = client.listFHIRExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRExportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFhirExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRExportJobsPublisher listFHIRExportJobsPaginator(ListFhirExportJobsRequest listFhirExportJobsRequest) {
        return new ListFHIRExportJobsPublisher(this, listFhirExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRExportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher publisher = client.listFHIRExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRExportJobsPublisher publisher = client.listFHIRExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRExportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirExportJobsRequest#builder()}
     * </p>
     *
     * @param listFhirExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRExportJobsPublisher listFHIRExportJobsPaginator(
            Consumer<ListFhirExportJobsRequest.Builder> listFhirExportJobsRequest) {
        return listFHIRExportJobsPaginator(ListFhirExportJobsRequest.builder().applyMutation(listFhirExportJobsRequest).build());
    }

    /**
     * <p>
     * List all FHIR import jobs associated with an account and their statuses.
     * </p>
     *
     * @param listFhirImportJobsRequest
     * @return A Java Future containing the result of the ListFHIRImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirImportJobsResponse> listFHIRImportJobs(ListFhirImportJobsRequest listFhirImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all FHIR import jobs associated with an account and their statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirImportJobsRequest#builder()}
     * </p>
     *
     * @param listFhirImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFHIRImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFhirImportJobsResponse> listFHIRImportJobs(
            Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) {
        return listFHIRImportJobs(ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRImportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher publisher = client.listFHIRImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher publisher = client.listFHIRImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRImportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFhirImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRImportJobsPublisher listFHIRImportJobsPaginator(ListFhirImportJobsRequest listFhirImportJobsRequest) {
        return new ListFHIRImportJobsPublisher(this, listFhirImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFHIRImportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher publisher = client.listFHIRImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.healthlake.paginators.ListFHIRImportJobsPublisher publisher = client.listFHIRImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFHIRImportJobs(software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFhirImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFhirImportJobsRequest#builder()}
     * </p>
     *
     * @param listFhirImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListFHIRImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListFHIRImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFHIRImportJobsPublisher listFHIRImportJobsPaginator(
            Consumer<ListFhirImportJobsRequest.Builder> listFhirImportJobsRequest) {
        return listFHIRImportJobsPaginator(ListFhirImportJobsRequest.builder().applyMutation(listFhirImportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all existing tags associated with a data store.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all existing tags associated with a data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Start a FHIR export job.
     * </p>
     *
     * @param startFhirExportJobRequest
     * @return A Java Future containing the result of the StartFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(StartFhirExportJobRequest startFhirExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start a FHIR export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFhirExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartFhirExportJobRequest#builder()}
     * </p>
     *
     * @param startFhirExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.StartFhirExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFHIRExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirExportJobResponse> startFHIRExportJob(
            Consumer<StartFhirExportJobRequest.Builder> startFhirExportJobRequest) {
        return startFHIRExportJob(StartFhirExportJobRequest.builder().applyMutation(startFhirExportJobRequest).build());
    }

    /**
     * <p>
     * Start importing bulk FHIR data into an ACTIVE data store. The import job imports FHIR data found in the
     * <code>InputDataConfig</code> object and stores processing results in the <code>JobOutputDataConfig</code> object.
     * </p>
     *
     * @param startFhirImportJobRequest
     * @return A Java Future containing the result of the StartFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(StartFhirImportJobRequest startFhirImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start importing bulk FHIR data into an ACTIVE data store. The import job imports FHIR data found in the
     * <code>InputDataConfig</code> object and stores processing results in the <code>JobOutputDataConfig</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFhirImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartFhirImportJobRequest#builder()}
     * </p>
     *
     * @param startFhirImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.StartFhirImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFHIRImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ThrottlingException The user has exceeded their maximum number of allowed calls to the given API.</li>
     *         <li>AccessDeniedException Access is denied. Your account is not authorized to perform this operation.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>InternalServerException An unknown internal error occurred in the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.StartFHIRImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/StartFHIRImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFhirImportJobResponse> startFHIRImportJob(
            Consumer<StartFhirImportJobRequest.Builder> startFhirImportJobRequest) {
        return startFHIRImportJob(StartFhirImportJobRequest.builder().applyMutation(startFhirImportJobRequest).build());
    }

    /**
     * <p>
     * Add a user-specifed key and value tag to a data store.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a user-specifed key and value tag to a data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove a user-specifed key and value tag from a data store.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a user-specifed key and value tag from a data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.healthlake.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The user input parameter was invalid.</li>
     *         <li>ResourceNotFoundException The requested data store was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>HealthLakeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample HealthLakeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/healthlake-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create an instance of {@link HealthLakeAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link HealthLakeAsyncWaiter}
     */
    default HealthLakeAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default HealthLakeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link HealthLakeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static HealthLakeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link HealthLakeAsyncClient}.
     */
    static HealthLakeAsyncClientBuilder builder() {
        return new DefaultHealthLakeAsyncClientBuilder();
    }
}
